/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.client.interest;

import com.netflix.eureka2.channel.InterestChannel;
import com.netflix.eureka2.client.EurekaInterestClient;
import com.netflix.eureka2.connection.RetryableConnection;
import com.netflix.eureka2.registry.Source;
import com.netflix.eureka2.registry.Sourced;
import com.netflix.eureka2.registry.SourcedEurekaRegistry;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import com.netflix.eureka2.utils.rx.RetryStrategyFunc;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

public abstract class AbstractInterestClient
implements EurekaInterestClient {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInterestClient.class);
    public static final int DEFAULT_RETRY_WAIT_MILLIS = 1000;
    protected final SourcedEurekaRegistry<InstanceInfo> registry;
    protected final int retryWaitMillis;
    protected final AtomicBoolean isShutdown;

    protected AbstractInterestClient(SourcedEurekaRegistry<InstanceInfo> registry, int retryWaitMillis) {
        this.registry = registry;
        this.retryWaitMillis = retryWaitMillis;
        this.isShutdown = new AtomicBoolean(false);
    }

    @Override
    public void shutdown() {
        if (this.isShutdown.compareAndSet(false, true)) {
            logger.info("Shutting down InterestClient");
            if (this.getRetryableConnection() != null) {
                this.getRetryableConnection().close();
            }
            this.registry.shutdown();
        }
    }

    protected abstract RetryableConnection<InterestChannel> getRetryableConnection();

    protected void registryEvictionSubscribe(RetryableConnection<InterestChannel> retryableConnection) {
        retryableConnection.getChannelObservable().flatMap((Func1)new Func1<InterestChannel, Observable<Long>>(){

            public Observable<Long> call(InterestChannel interestChannel) {
                if (interestChannel instanceof Sourced) {
                    Source toRetain = ((Sourced)((Object)interestChannel)).getSource();
                    return AbstractInterestClient.this.registry.evictAllExcept(Source.matcherFor(toRetain));
                }
                return Observable.empty();
            }
        }).subscribe((Subscriber)new Subscriber<Long>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Long aLong) {
                logger.info("Evicted {} instances in one round of eviction due to a new interestChannel creation", (Object)aLong);
            }
        });
    }

    protected void lifecycleSubscribe(RetryableConnection<InterestChannel> retryableConnection) {
        retryableConnection.getRetryableLifecycle().retryWhen((Func1)new RetryStrategyFunc(this.retryWaitMillis)).subscribe((Subscriber)new Subscriber<Void>(){

            public void onCompleted() {
                logger.info("channel onCompleted");
            }

            public void onError(Throwable e) {
                logger.error("Lifecycle closed with an error");
            }

            public void onNext(Void aVoid) {
            }
        });
    }
}

