/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.client.resolver;

import com.netflix.eureka2.Server;
import com.netflix.eureka2.client.resolver.HostResolverStep;
import com.netflix.eureka2.client.resolver.RoundRobinServerResolver;
import com.netflix.eureka2.client.resolver.ServerResolver;
import com.netflix.eureka2.interests.ChangeNotification;
import com.netflix.eureka2.interests.host.DnsResolver;
import java.util.Set;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class DnsResolverStep
implements HostResolverStep {
    private final String dnsName;
    private final Scheduler dnsLoadScheduler;

    DnsResolverStep(String dnsName) {
        this.dnsName = dnsName;
        this.dnsLoadScheduler = Schedulers.io();
    }

    DnsResolverStep configureDnsNameSource(final Observable<ChangeNotification<String>> changeNotificationSource) {
        return new DnsResolverStep(this.dnsName){

            @Override
            protected Observable<ChangeNotification<String>> createDnsChangeNotificationSource() {
                return changeNotificationSource;
            }
        };
    }

    protected Observable<ChangeNotification<String>> createDnsChangeNotificationSource() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<ChangeNotification<String>>(){

            public void call(Subscriber<? super ChangeNotification<String>> subscriber) {
                try {
                    Set<ChangeNotification<String>> names = DnsResolver.resolveServerDN(DnsResolverStep.this.dnsName);
                    Observable.from(names).subscribe(subscriber);
                }
                catch (Exception e) {
                    subscriber.onError((Throwable)e);
                }
            }
        }).subscribeOn(this.dnsLoadScheduler);
    }

    @Override
    public ServerResolver withPort(final int port) {
        Observable<ChangeNotification<String>> dnsChangeNotificationSource = this.createDnsChangeNotificationSource();
        Observable serverSource = dnsChangeNotificationSource.map((Func1)new Func1<ChangeNotification<String>, ChangeNotification<Server>>(){

            public ChangeNotification<Server> call(ChangeNotification<String> notification) {
                switch (notification.getKind()) {
                    case BufferSentinel: {
                        return ChangeNotification.bufferSentinel();
                    }
                    case Add: {
                        return new ChangeNotification<Server>(ChangeNotification.Kind.Add, new Server(notification.getData(), port));
                    }
                    case Delete: {
                        return new ChangeNotification<Server>(ChangeNotification.Kind.Delete, new Server(notification.getData(), port));
                    }
                }
                return null;
            }
        }).filter((Func1)new Func1<ChangeNotification<Server>, Boolean>(){

            public Boolean call(ChangeNotification<Server> notification) {
                return notification != null;
            }
        });
        RoundRobinServerResolver resolver = new RoundRobinServerResolver((Observable<ChangeNotification<Server>>)serverSource);
        return resolver;
    }
}

