/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.client.resolver;

import com.netflix.eureka2.Server;
import com.netflix.eureka2.client.resolver.DefaultEurekaResolverStep;
import com.netflix.eureka2.client.resolver.DefaultPortResolverStep;
import com.netflix.eureka2.client.resolver.DnsResolverStep;
import com.netflix.eureka2.client.resolver.EurekaRemoteResolverStep;
import com.netflix.eureka2.client.resolver.FallbackServerResolver;
import com.netflix.eureka2.client.resolver.FileServerResolver;
import com.netflix.eureka2.client.resolver.FixedHostResolverStep;
import com.netflix.eureka2.client.resolver.HostResolverStep;
import com.netflix.eureka2.client.resolver.PortResolverStep;
import com.netflix.eureka2.client.resolver.RoundRobinServerResolver;
import com.netflix.eureka2.client.resolver.ServerResolver;
import com.netflix.eureka2.interests.ChangeNotification;
import java.io.File;
import rx.Observable;

public class ServerResolvers {
    public static ServerResolver from(Server ... servers) {
        return new RoundRobinServerResolver(servers);
    }

    public static ServerResolver fromServerSource(Observable<ChangeNotification<Server>> serverSource) {
        return new RoundRobinServerResolver(serverSource);
    }

    public static PortResolverStep fromPort(int port) {
        return new DefaultPortResolverStep(port);
    }

    public static HostResolverStep fromHostname(String hostname) {
        return new FixedHostResolverStep(hostname);
    }

    public static DnsResolverStep fromDnsName(String dnsName) {
        return new DnsResolverStep(dnsName);
    }

    public static ServerResolver fromFile(File file) {
        return new FileServerResolver(file);
    }

    public static EurekaRemoteResolverStep fromEureka(ServerResolver serverToReadFrom) {
        return new DefaultEurekaResolverStep(serverToReadFrom);
    }

    public static ServerResolver fallbackResolver(ServerResolver primary, ServerResolver fallback) {
        return new FallbackServerResolver(primary, fallback);
    }
}

