/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.client.transport;

import com.eureka2.shading.reactivex.netty.RxNetty;
import com.eureka2.shading.reactivex.netty.channel.ObservableConnection;
import com.eureka2.shading.reactivex.netty.client.RxClient;
import com.eureka2.shading.reactivex.netty.pipeline.PipelineConfigurator;
import com.netflix.eureka2.Server;
import com.netflix.eureka2.client.resolver.ServerResolver;
import com.netflix.eureka2.config.EurekaTransportConfig;
import com.netflix.eureka2.metric.MessageConnectionMetrics;
import com.netflix.eureka2.transport.MessageConnection;
import com.netflix.eureka2.transport.TransportClient;
import com.netflix.eureka2.transport.base.BaseMessageConnection;
import com.netflix.eureka2.transport.base.HeartBeatConnection;
import com.netflix.eureka2.transport.base.SelfClosingConnection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public abstract class ResolverBasedTransportClient
implements TransportClient {
    private static final Logger logger = LoggerFactory.getLogger(ResolverBasedTransportClient.class);
    private final String clientId;
    private final AtomicInteger clientInstanceIdx = new AtomicInteger();
    private final EurekaTransportConfig config;
    private final ServerResolver resolver;
    private final PipelineConfigurator<Object, Object> pipelineConfigurator;
    private final MessageConnectionMetrics metrics;
    private final ConcurrentHashMap<Server, RxClient<Object, Object>> clients;

    protected ResolverBasedTransportClient(String clientId, EurekaTransportConfig config, ServerResolver resolver, PipelineConfigurator<Object, Object> pipelineConfigurator, MessageConnectionMetrics metrics) {
        this.clientId = clientId;
        this.config = config;
        this.resolver = resolver;
        this.pipelineConfigurator = pipelineConfigurator;
        this.metrics = metrics;
        this.clients = new ConcurrentHashMap();
    }

    @Override
    public Observable<MessageConnection> connect() {
        return this.resolver.resolve().take(1).map((Func1)new Func1<Server, RxClient<Object, Object>>(){

            public RxClient<Object, Object> call(Server server) {
                RxClient client = (RxClient)ResolverBasedTransportClient.this.clients.get(server);
                if (null == client) {
                    client = RxNetty.createTcpClient(server.getHost(), server.getPort(), ResolverBasedTransportClient.this.pipelineConfigurator);
                    ResolverBasedTransportClient.this.clients.put(server, client);
                }
                logger.info("Connecting to server {}", (Object)server);
                return client;
            }
        }).flatMap((Func1)new Func1<RxClient<Object, Object>, Observable<MessageConnection>>(){

            public Observable<MessageConnection> call(RxClient<Object, Object> client) {
                return client.connect().map((Func1)new Func1<ObservableConnection<Object, Object>, MessageConnection>(){

                    public MessageConnection call(ObservableConnection<Object, Object> conn) {
                        String clientInstanceId = ResolverBasedTransportClient.this.clientId + '#' + ResolverBasedTransportClient.this.clientInstanceIdx.incrementAndGet();
                        return new SelfClosingConnection(new HeartBeatConnection(new BaseMessageConnection(clientInstanceId, conn, ResolverBasedTransportClient.this.metrics), ResolverBasedTransportClient.this.config.getHeartbeatIntervalMs(), 3L, Schedulers.computation()), ResolverBasedTransportClient.this.config.getConnectionAutoTimeoutMs());
                    }
                });
            }
        });
    }

    @Override
    public void shutdown() {
        for (RxClient<Object, Object> client : this.clients.values()) {
            client.shutdown();
        }
    }
}

