/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.codec.avro;

import com.eureka2.shading.apache.avro.Schema;
import com.eureka2.shading.apache.avro.io.BinaryDecoder;
import com.eureka2.shading.apache.avro.io.BinaryEncoder;
import com.eureka2.shading.apache.avro.io.DecoderFactory;
import com.eureka2.shading.apache.avro.io.EncoderFactory;
import com.eureka2.shading.apache.avro.reflect.ReflectData;
import com.eureka2.shading.apache.avro.reflect.ReflectDatumReader;
import com.eureka2.shading.apache.avro.reflect.ReflectDatumWriter;
import com.netflix.eureka2.codec.EurekaCodec;
import com.netflix.eureka2.codec.avro.SchemaReflectData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;

public class EurekaAvroCodec<T>
implements EurekaCodec<T> {
    private final Set<Class<?>> protocolTypes;
    private final ReflectDatumWriter<Object> datumWriter;
    private final ReflectDatumReader<Object> datumReader;
    private BinaryEncoder encoder;
    private BinaryDecoder decoder;

    public EurekaAvroCodec(Set<Class<?>> protocolTypes, Schema rootSchema) {
        this(protocolTypes, rootSchema, new SchemaReflectData(rootSchema));
    }

    public EurekaAvroCodec(Set<Class<?>> protocolTypes, Schema rootSchema, SchemaReflectData reflectData) {
        this.protocolTypes = protocolTypes;
        this.datumWriter = new ReflectDatumWriter(rootSchema, (ReflectData)reflectData);
        this.datumReader = new ReflectDatumReader(rootSchema, rootSchema, reflectData);
    }

    @Override
    public boolean accept(Class<?> valueType) {
        return this.protocolTypes.contains(valueType);
    }

    @Override
    public void encode(T value, OutputStream output) throws IOException {
        this.encoder = EncoderFactory.get().binaryEncoder(output, this.encoder);
        this.datumWriter.write(value, this.encoder);
        this.encoder.flush();
        output.close();
    }

    @Override
    public T decode(InputStream source) throws IOException {
        this.decoder = DecoderFactory.get().binaryDecoder(source, this.decoder);
        return this.datumReader.read(null, this.decoder);
    }
}

