/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.codec.json;

import com.eureka2.shading.codehaus.jackson.JsonGenerator;
import com.eureka2.shading.codehaus.jackson.JsonNode;
import com.eureka2.shading.codehaus.jackson.JsonParseException;
import com.eureka2.shading.codehaus.jackson.JsonParser;
import com.eureka2.shading.codehaus.jackson.annotate.JsonAutoDetect;
import com.eureka2.shading.codehaus.jackson.annotate.JsonMethod;
import com.eureka2.shading.codehaus.jackson.map.DeserializationConfig;
import com.eureka2.shading.codehaus.jackson.map.DeserializationContext;
import com.eureka2.shading.codehaus.jackson.map.DeserializerFactory;
import com.eureka2.shading.codehaus.jackson.map.JsonDeserializer;
import com.eureka2.shading.codehaus.jackson.map.JsonMappingException;
import com.eureka2.shading.codehaus.jackson.map.JsonSerializer;
import com.eureka2.shading.codehaus.jackson.map.ObjectMapper;
import com.eureka2.shading.codehaus.jackson.map.SerializationConfig;
import com.eureka2.shading.codehaus.jackson.map.SerializerFactory;
import com.eureka2.shading.codehaus.jackson.map.SerializerProvider;
import com.eureka2.shading.codehaus.jackson.map.deser.BeanDeserializerBuilder;
import com.eureka2.shading.codehaus.jackson.map.deser.BeanDeserializerFactory;
import com.eureka2.shading.codehaus.jackson.map.deser.BeanDeserializerModifier;
import com.eureka2.shading.codehaus.jackson.map.deser.SettableBeanProperty;
import com.eureka2.shading.codehaus.jackson.map.deser.StdDeserializerProvider;
import com.eureka2.shading.codehaus.jackson.map.introspect.BasicBeanDescription;
import com.eureka2.shading.codehaus.jackson.map.module.SimpleSerializers;
import com.eureka2.shading.codehaus.jackson.map.ser.BeanSerializerFactory;
import com.eureka2.shading.codehaus.jackson.map.ser.BeanSerializerModifier;
import com.eureka2.shading.codehaus.jackson.map.ser.std.BeanSerializerBase;
import com.eureka2.shading.codehaus.jackson.node.ArrayNode;
import com.netflix.eureka2.codec.EurekaCodec;
import com.netflix.eureka2.utils.Json;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class EurekaJsonCodec<T>
implements EurekaCodec<T> {
    private final ObjectMapper mapper;
    private final Set<Class<?>> acceptedTypes;

    public EurekaJsonCodec(Set<Class<?>> acceptedTypes) {
        this.acceptedTypes = acceptedTypes;
        this.mapper = new ObjectMapper();
        SimpleSerializers serializers = new SimpleSerializers();
        serializers.addSerializer(Enum.class, new EnumSerializer());
        SerializerFactory serializerFactory = BeanSerializerFactory.instance.withAdditionalSerializers(serializers).withSerializerModifier(new TypeInjectingModifier());
        DeserializerFactory deserializerFactory = BeanDeserializerFactory.instance.withDeserializerModifier(new TypeResolvingModifier(this.mapper));
        this.mapper.setSerializerFactory(serializerFactory);
        this.mapper.setDeserializerProvider(new StdDeserializerProvider(deserializerFactory));
        this.mapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        this.mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
        this.mapper.configure(SerializationConfig.Feature.AUTO_DETECT_GETTERS, false);
    }

    @Override
    public boolean accept(Class<?> valueType) {
        return this.acceptedTypes.contains(valueType);
    }

    @Override
    public void encode(T value, OutputStream output) throws IOException {
        this.mapper.writeValue(output, value);
    }

    public <C> void encodeContainer(C container, OutputStream output) throws IOException {
        this.mapper.writeValue(output, container);
    }

    @Override
    public T decode(InputStream source) throws IOException {
        return (T)this.decodeJson(source);
    }

    public <C> C decodeContainer(Class<C> containerType, InputStream source) throws IOException {
        return (C)this.decodeJson(source);
    }

    private Object decodeJson(InputStream source) throws IOException {
        Class<?> contentClass;
        JsonNode jsonNode = Json.getMapper().readTree(source);
        String messageType = jsonNode.get("_type").asText();
        try {
            contentClass = Class.forName(messageType);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Incompatible encoded value format", e);
        }
        return this.mapper.readValue(jsonNode, contentClass);
    }

    private static Class<?> getObjectType(JsonParser jp, JsonNode tree) throws JsonParseException {
        Class<?> objectClass;
        String type = tree.get("_type").asText();
        try {
            objectClass = Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new JsonParseException("Cannot instantiate type " + type, jp.getCurrentLocation());
        }
        return objectClass;
    }

    private static Enum deserializeEnum(JsonParser jp, JsonNode tree) throws IOException {
        Class<?> enumType = EurekaJsonCodec.getObjectType(jp, tree);
        String enumValue = tree.get("value").asText();
        for (Enum value : (Enum[])enumType.getEnumConstants()) {
            if (!value.name().equals(enumValue)) continue;
            return value;
        }
        throw new JsonMappingException(String.format("Unrecognized enum value for type %s for type %s", enumValue, enumType));
    }

    static class TypeResolvingModifier
    extends BeanDeserializerModifier {
        private final ObjectMapper mapper;

        TypeResolvingModifier(ObjectMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BasicBeanDescription beanDesc, BeanDeserializerBuilder builder) {
            Iterator<SettableBeanProperty> beanPropertyIterator = builder.getProperties();
            while (beanPropertyIterator.hasNext()) {
                SettableBeanProperty settableBeanProperty = beanPropertyIterator.next();
                Class<?> rawClass = settableBeanProperty.getType().getRawClass();
                if (this.isBasicType(rawClass)) continue;
                SettableBeanProperty newSettableBeanProperty = settableBeanProperty.withValueDeserializer(new PolymorphicDeserializer(rawClass, this.mapper));
                builder.addOrReplaceProperty(newSettableBeanProperty, true);
            }
            return builder;
        }

        private boolean isBasicType(Class<?> rawClass) {
            Class<?> type;
            Class<?> clazz = type = rawClass.isArray() ? rawClass.getComponentType() : rawClass;
            if (type.isPrimitive() || type.equals(String.class)) {
                return true;
            }
            if (Number.class.isAssignableFrom(rawClass)) {
                return true;
            }
            if (Collection.class.isAssignableFrom(rawClass)) {
                return true;
            }
            return Map.class.isAssignableFrom(rawClass);
        }
    }

    static class PolymorphicDeserializer
    extends JsonDeserializer<Object> {
        private final Class<?> rawClass;
        private final ObjectMapper mapper;

        PolymorphicDeserializer(Class<?> rawClass, ObjectMapper mapper) {
            this.rawClass = rawClass;
            this.mapper = mapper;
        }

        @Override
        public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode tree = jp.readValueAsTree();
            if (tree instanceof ArrayNode) {
                return this.handleArray(jp, (ArrayNode)tree);
            }
            return this.handleObject(jp, tree);
        }

        private Object handleObject(JsonParser jp, JsonNode tree) throws IOException {
            Class objectClass = EurekaJsonCodec.getObjectType(jp, tree);
            if (objectClass.isEnum()) {
                return EurekaJsonCodec.deserializeEnum(jp, tree);
            }
            return this.mapper.readValue(tree, objectClass);
        }

        private Object handleArray(JsonParser jp, ArrayNode arrayNode) throws IOException {
            Object[] arrayInstance = (Object[])Array.newInstance(this.rawClass.getComponentType(), arrayNode.size());
            for (int i = 0; i < arrayInstance.length; ++i) {
                Object value;
                arrayInstance[i] = value = this.handleObject(jp, arrayNode.get(i));
            }
            return arrayInstance;
        }
    }

    static class TypeInjectingModifier
    extends BeanSerializerModifier {
        TypeInjectingModifier() {
        }

        @Override
        public JsonSerializer<?> modifySerializer(SerializationConfig config, BasicBeanDescription beanDesc, JsonSerializer<?> serializer) {
            if (serializer == null) {
                return new EmptyBeanSerializer();
            }
            return new TypeInjectingSerializer((BeanSerializerBase)serializer);
        }

        static class EmptyBeanSerializer
        extends JsonSerializer<Object> {
            EmptyBeanSerializer() {
            }

            @Override
            public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeStartObject();
                jgen.writeStringField("_type", value.getClass().getName());
                jgen.writeEndObject();
            }
        }

        static class TypeInjectingSerializer
        extends BeanSerializerBase {
            TypeInjectingSerializer(BeanSerializerBase source) {
                super(source);
            }

            @Override
            public void serialize(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeStartObject();
                this.serializeFields(bean, jgen, provider);
                jgen.writeStringField("_type", bean.getClass().getName());
                jgen.writeEndObject();
            }
        }
    }

    static class EnumSerializer
    extends JsonSerializer<Enum> {
        EnumSerializer() {
        }

        @Override
        public void serialize(Enum value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStartObject();
            jgen.writeStringField("_type", value.getClass().getName());
            jgen.writeStringField("value", value.toString());
            jgen.writeEndObject();
        }
    }
}

