/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.config;

import com.netflix.eureka2.config.EurekaRegistryConfig;
import com.netflix.eureka2.config.SystemConfigLoader;
import com.netflix.eureka2.registry.eviction.EvictionStrategyProvider;

public class BasicEurekaRegistryConfig
implements EurekaRegistryConfig {
    public static final long EVICTION_TIMEOUT_MS = 30000L;
    public static final EvictionStrategyProvider.StrategyType EVICTION_STRATEGY_TYPE = EvictionStrategyProvider.StrategyType.PercentageDrop;
    public static final String EVICTION_STRATEGY_VALUE = "20";
    private final Long evictionTimeoutMs;
    private final EvictionStrategyProvider.StrategyType evictionStrategyType;
    private final String evictionStrategyValue;

    private BasicEurekaRegistryConfig(Long evictionTimeoutMs, EvictionStrategyProvider.StrategyType evictionStrategyType, String evictionStrategyValue) {
        this.evictionTimeoutMs = evictionTimeoutMs;
        this.evictionStrategyType = evictionStrategyType;
        this.evictionStrategyValue = evictionStrategyValue;
    }

    @Override
    public long getEvictionTimeoutMs() {
        return this.evictionTimeoutMs;
    }

    @Override
    public EvictionStrategyProvider.StrategyType getEvictionStrategyType() {
        return this.evictionStrategyType;
    }

    @Override
    public String getEvictionStrategyValue() {
        return this.evictionStrategyValue;
    }

    public String toString() {
        return "BasicEurekaRegistryConfig{evictionTimeoutMs='" + this.evictionTimeoutMs + '\'' + ", evictionStrategyType='" + (Object)((Object)this.evictionStrategyType) + '\'' + ", evictionStrategyValue='" + this.evictionStrategyValue + '\'' + '}';
    }

    public static class Builder {
        private Long evictionTimeoutMs = SystemConfigLoader.getFromSystemPropertySafe("eureka.registry.evictionTimeoutMs", 30000L);
        private EvictionStrategyProvider.StrategyType evictionStrategyType = SystemConfigLoader.getFromSystemPropertySafe("eureka.registry.evictionStrategy.type", EVICTION_STRATEGY_TYPE);
        private String evictionStrategyValue = SystemConfigLoader.getFromSystemPropertySafe("eureka.registry.evictionStrategy.value", "20");

        public Builder withEvictionTimeoutMs(Long evictionTimeoutMs) {
            this.evictionTimeoutMs = evictionTimeoutMs;
            return this;
        }

        public Builder withEvictionStrategyType(EvictionStrategyProvider.StrategyType evictionStrategyType) {
            this.evictionStrategyType = evictionStrategyType;
            return this;
        }

        public Builder withEvictionStrategyValue(String evictionStrategyValue) {
            this.evictionStrategyValue = evictionStrategyValue;
            return this;
        }

        public BasicEurekaRegistryConfig build() {
            return new BasicEurekaRegistryConfig(this.evictionTimeoutMs, this.evictionStrategyType, this.evictionStrategyValue);
        }
    }
}

