/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemConfigLoader {
    private static final Logger logger = LoggerFactory.getLogger(SystemConfigLoader.class);

    public static long getFromSystemPropertySafe(String key, long defaultValue) {
        long result;
        try {
            result = Long.parseLong(System.getProperty(key, "" + defaultValue));
        }
        catch (Exception e) {
            logger.warn("Error loading system property {}. Using a default {}", (Object)key, (Object)defaultValue);
            result = defaultValue;
        }
        return result;
    }

    public static String getFromSystemPropertySafe(String key, String defaultValue) {
        String result;
        try {
            result = System.getProperty(key, defaultValue);
        }
        catch (Exception e) {
            logger.warn("Error loading system property {}. Using a default {}", (Object)key, (Object)defaultValue);
            result = defaultValue;
        }
        return result;
    }

    public static <E extends Enum<E>> E getFromSystemPropertySafe(String key, E defaultValue) {
        E result;
        try {
            result = Enum.valueOf(defaultValue.getDeclaringClass(), System.getProperty(key, defaultValue.name()));
        }
        catch (Exception e) {
            logger.warn("Error loading system property {}. Using a default {}", (Object)key, defaultValue);
            result = defaultValue;
        }
        return result;
    }
}

