/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.eureka1.utils;

import com.netflix.eureka2.client.EurekaInterestClient;
import com.netflix.eureka2.client.EurekaInterestClientBuilder;
import com.netflix.eureka2.client.Eurekas;
import com.netflix.eureka2.client.functions.InterestFunctions;
import com.netflix.eureka2.client.resolver.ServerResolver;
import com.netflix.eureka2.eureka1.utils.Eureka1ModelConverters;
import com.netflix.eureka2.interests.Interest;
import com.netflix.eureka2.interests.Interests;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscription;
import rx.functions.Action1;

public class ServerListReader {
    private static final Logger logger = LoggerFactory.getLogger(ServerListReader.class);
    public static final int FIRST_RESOLVE_TIMEOUT_SEC = 30;
    private final EurekaInterestClient interestClient;
    private final Subscription subscription;
    private final AtomicReference<List<com.netflix.appinfo.InstanceInfo>> latestServerList = new AtomicReference(Collections.emptyList());
    private final CountDownLatch firstBatchLatch = new CountDownLatch(1);
    private final long firstResolveTimeoutMs;

    public ServerListReader(ServerResolver serverResolver, String[] serviceVips, boolean isSecure) {
        this(serverResolver, serviceVips, isSecure, 30L, TimeUnit.SECONDS);
    }

    public ServerListReader(ServerResolver serverResolver, String[] serviceVips, boolean isSecure, long firstResolveTimeout, TimeUnit timeUnit) {
        this((EurekaInterestClient)((EurekaInterestClientBuilder)Eurekas.newInterestClientBuilder().withServerResolver(serverResolver)).build(), serviceVips, isSecure, firstResolveTimeout, timeUnit);
    }

    public ServerListReader(EurekaInterestClient interestClient, String[] serviceVips, boolean isSecure) {
        this(interestClient, serviceVips, isSecure, 30L, TimeUnit.SECONDS);
    }

    public ServerListReader(EurekaInterestClient interestClient, final String[] serviceVips, boolean isSecure, long firstResolveTimeout, TimeUnit timeUnit) {
        this.interestClient = interestClient;
        this.firstResolveTimeoutMs = timeUnit.toMillis(firstResolveTimeout);
        Interest<InstanceInfo> interest = isSecure ? Interests.forSecureVips(serviceVips) : Interests.forVips(serviceVips);
        this.subscription = interestClient.forInterest(interest).compose(InterestFunctions.buffers()).compose(InterestFunctions.snapshots()).doOnNext((Action1)new Action1<LinkedHashSet<InstanceInfo>>(){

            public void call(LinkedHashSet<InstanceInfo> instanceInfos) {
                if (!instanceInfos.isEmpty()) {
                    ServerListReader.this.latestServerList.set(Eureka1ModelConverters.toEureka1xInstanceInfos(instanceInfos));
                    ServerListReader.this.firstBatchLatch.countDown();
                }
            }
        }).doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable e) {
                logger.error("Cannot resolve servers for vip addresses " + Arrays.toString(serviceVips), e);
            }
        }).subscribe();
    }

    public List<com.netflix.appinfo.InstanceInfo> getLatestServerList() {
        return this.latestServerList.get();
    }

    public List<com.netflix.appinfo.InstanceInfo> getLatestServerListOrWait() {
        try {
            this.firstBatchLatch.await(this.firstResolveTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.latestServerList.get();
    }

    public void shutdown() {
        this.subscription.unsubscribe();
        this.interestClient.shutdown();
    }
}

