/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.interests;

import com.netflix.eureka2.interests.Interest;
import java.util.regex.Pattern;

public abstract class AbstractPatternInterest<T>
extends Interest<T> {
    private final String pattern;
    private final Interest.Operator operator;
    private volatile Pattern compiledPattern;

    protected AbstractPatternInterest() {
        this.pattern = null;
        this.operator = null;
    }

    protected AbstractPatternInterest(String pattern) {
        this(pattern, Interest.Operator.Equals);
    }

    protected AbstractPatternInterest(String pattern, Interest.Operator operator) {
        if (pattern == null) {
            throw new IllegalArgumentException("Expected non null pattern value");
        }
        if (operator == null) {
            throw new IllegalArgumentException("Expected non null operator value");
        }
        this.pattern = pattern;
        this.operator = operator;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Interest.Operator getOperator() {
        return this.operator;
    }

    @Override
    public boolean matches(T data) {
        String value = this.getValue(data);
        if (value == null) {
            return false;
        }
        if (this.operator != Interest.Operator.Like) {
            return this.pattern.equals(value);
        }
        if (this.compiledPattern == null) {
            this.compiledPattern = Pattern.compile(this.pattern);
        }
        return this.compiledPattern.matcher(value).matches();
    }

    protected abstract String getValue(T var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPatternInterest that = (AbstractPatternInterest)o;
        if (this.compiledPattern != null ? !this.compiledPattern.equals(that.compiledPattern) : that.compiledPattern != null) {
            return false;
        }
        if (this.operator != that.operator) {
            return false;
        }
        return !(this.pattern != null ? !this.pattern.equals(that.pattern) : that.pattern != null);
    }

    public int hashCode() {
        int result = this.pattern != null ? this.pattern.hashCode() : 0;
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.compiledPattern != null ? this.compiledPattern.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + "pattern='" + this.pattern + '\'' + ", operator=" + (Object)((Object)this.operator) + ", compiledPattern=" + this.compiledPattern + '}';
    }
}

