/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.interests;

public class ChangeNotification<T> {
    private static final ChangeNotification<?> BUFFER_SENTINEL = new ChangeNotification<Object>(Kind.BufferSentinel, null);
    private final Kind kind;
    private final T data;

    public ChangeNotification(Kind kind, T data) {
        if (null == kind) {
            throw new NullPointerException("Notification kind can not be null.");
        }
        if (null == data && ChangeNotification._isDataNotification(kind)) {
            throw new NullPointerException("Data can not be null.");
        }
        this.kind = kind;
        this.data = data;
    }

    public boolean isDataNotification() {
        return ChangeNotification._isDataNotification(this.kind);
    }

    public Kind getKind() {
        return this.kind;
    }

    public T getData() {
        return this.data;
    }

    public String toString() {
        return "ChangeNotification{kind=" + (Object)((Object)this.kind) + ", data=" + this.data + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeNotification that = (ChangeNotification)o;
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        return this.kind == that.kind;
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        return result;
    }

    public static <T> ChangeNotification<T> bufferSentinel() {
        return BUFFER_SENTINEL;
    }

    private static boolean _isDataNotification(Kind kind) {
        return kind == Kind.Add || kind == Kind.Delete || kind == Kind.Modify;
    }

    public static enum Kind {
        Add,
        Delete,
        Modify,
        BufferSentinel;

    }
}

