/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.interests;

import com.netflix.eureka2.interests.ChangeNotification;
import com.netflix.eureka2.interests.StreamStateNotification;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import com.netflix.eureka2.utils.rx.RxFunctions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import rx.Notification;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public final class ChangeNotifications {
    private static final Func1<ChangeNotification<?>, Boolean> DATA_ONLY_FILTER_FUNC = new Func1<ChangeNotification<?>, Boolean>(){

        public Boolean call(ChangeNotification<?> notification) {
            return notification.isDataNotification();
        }
    };
    private static final Func1<ChangeNotification<?>, Boolean> STREAM_STATE_FILTER_FUNC = new Func1<ChangeNotification<?>, Boolean>(){

        public Boolean call(ChangeNotification<?> notification) {
            return notification instanceof StreamStateNotification;
        }
    };
    private static final Comparator<InstanceInfo> INSTANCE_INFO_IDENTITY_COMPARATOR = new Comparator<InstanceInfo>(){

        @Override
        public int compare(InstanceInfo o1, InstanceInfo o2) {
            return o1.getId().compareTo(o2.getId());
        }
    };

    private ChangeNotifications() {
    }

    public static Comparator<InstanceInfo> instanceInfoIdentityComparator() {
        return INSTANCE_INFO_IDENTITY_COMPARATOR;
    }

    public static <T> Observable<ChangeNotification<T>> from(T ... values) {
        if (values == null || values.length == 0) {
            return Observable.empty();
        }
        ArrayList<ChangeNotification<T>> notifications = new ArrayList<ChangeNotification<T>>(values.length);
        for (T value : values) {
            notifications.add(new ChangeNotification<T>(ChangeNotification.Kind.Add, value));
        }
        return Observable.from(notifications);
    }

    public static Func1<ChangeNotification<?>, Boolean> dataOnlyFilter() {
        return DATA_ONLY_FILTER_FUNC;
    }

    public static Func1<ChangeNotification<?>, Boolean> streamStateFilter() {
        return STREAM_STATE_FILTER_FUNC;
    }

    public static <T> Func1<T, ChangeNotification<T>> toAddChangeNotification() {
        return new Func1<T, ChangeNotification<T>>(){

            public ChangeNotification<T> call(T data) {
                return new ChangeNotification(ChangeNotification.Kind.Add, data);
            }
        };
    }

    public static <T> SortedSet<T> collapseAndExtract(List<ChangeNotification<T>> notifications, Comparator<T> identityComparator) {
        List<ChangeNotification<T>> collapsed = ChangeNotifications.collapse(notifications, identityComparator);
        TreeSet<T> result = new TreeSet<T>(identityComparator);
        for (ChangeNotification<T> item : collapsed) {
            if (item.getKind() != ChangeNotification.Kind.Add && item.getKind() != ChangeNotification.Kind.Modify) continue;
            result.add(item.getData());
        }
        return result;
    }

    public static <T> Observable.Transformer<ChangeNotification<T>, List<ChangeNotification<T>>> delineatedBuffers() {
        return new Observable.Transformer<ChangeNotification<T>, List<ChangeNotification<T>>>(){

            public Observable<List<ChangeNotification<T>>> call(Observable<ChangeNotification<T>> notifications) {
                final AtomicBoolean bufferStart = new AtomicBoolean();
                final AtomicReference bufferRef = new AtomicReference();
                return notifications.map(new Func1<ChangeNotification<T>, List<ChangeNotification<T>>>(){

                    /*
                     * Enabled aggressive block sorting
                     */
                    public List<ChangeNotification<T>> call(ChangeNotification<T> notification) {
                        ArrayList buffer = (ArrayList)bufferRef.get();
                        if (notification instanceof StreamStateNotification) {
                            StreamStateNotification.BufferState bufferState = ((StreamStateNotification)notification).getBufferState();
                            if (bufferState == StreamStateNotification.BufferState.BufferStart) {
                                bufferStart.set(true);
                                return null;
                            }
                            bufferStart.set(false);
                            bufferRef.set(null);
                            return buffer;
                        }
                        if (!bufferStart.get()) return Collections.singletonList(notification);
                        if (buffer == null) {
                            buffer = new ArrayList();
                            bufferRef.set(buffer);
                        }
                        buffer.add(notification);
                        return null;
                    }
                }).filter(RxFunctions.filterNullValuesFunc());
            }
        };
    }

    public static <T> Observable.Transformer<ChangeNotification<T>, List<ChangeNotification<T>>> buffers() {
        return new Observable.Transformer<ChangeNotification<T>, List<ChangeNotification<T>>>(){

            public Observable<List<ChangeNotification<T>>> call(Observable<ChangeNotification<T>> notifications) {
                final AtomicReference bufferRef = new AtomicReference();
                bufferRef.set(new ArrayList());
                return notifications.filter(RxFunctions.filterNullValuesFunc()).materialize().concatMap(new Func1<Notification<ChangeNotification<T>>, Observable<List<ChangeNotification<T>>>>(){

                    public Observable<List<ChangeNotification<T>>> call(Notification<ChangeNotification<T>> rxNotification) {
                        List buffer = (List)bufferRef.get();
                        switch (rxNotification.getKind()) {
                            case OnNext: {
                                ChangeNotification notification = (ChangeNotification)rxNotification.getValue();
                                if (notification.getKind() == ChangeNotification.Kind.BufferSentinel) {
                                    bufferRef.set(new ArrayList());
                                    return Observable.just((Object)buffer);
                                }
                                buffer.add(notification);
                                break;
                            }
                            case OnCompleted: {
                                return Observable.just((Object)buffer);
                            }
                            case OnError: {
                                bufferRef.set(new ArrayList());
                                return Observable.error((Throwable)rxNotification.getThrowable());
                            }
                        }
                        return Observable.empty();
                    }
                });
            }
        };
    }

    public static <T> Observable.Transformer<List<ChangeNotification<T>>, LinkedHashSet<T>> snapshots() {
        final LinkedHashSet snapshotSet = new LinkedHashSet();
        return new Observable.Transformer<List<ChangeNotification<T>>, LinkedHashSet<T>>(){

            public Observable<LinkedHashSet<T>> call(Observable<List<ChangeNotification<T>>> batches) {
                return batches.map(new Func1<List<ChangeNotification<T>>, LinkedHashSet<T>>(){

                    public LinkedHashSet<T> call(List<ChangeNotification<T>> batch) {
                        for (ChangeNotification item : batch) {
                            switch (item.getKind()) {
                                case Add: 
                                case Modify: {
                                    snapshotSet.add(item.getData());
                                    break;
                                }
                                case Delete: {
                                    snapshotSet.remove(item.getData());
                                    break;
                                }
                            }
                        }
                        return new LinkedHashSet(snapshotSet);
                    }
                });
            }
        };
    }

    public static <T> Observable.Transformer<List<ChangeNotification<T>>, List<ChangeNotification<T>>> collapse(final Comparator<T> identityComparator) {
        return new Observable.Transformer<List<ChangeNotification<T>>, List<ChangeNotification<T>>>(){

            public Observable<List<ChangeNotification<T>>> call(Observable<List<ChangeNotification<T>>> listObservable) {
                return listObservable.map(new Func1<List<ChangeNotification<T>>, List<ChangeNotification<T>>>(){

                    public List<ChangeNotification<T>> call(List<ChangeNotification<T>> notifications) {
                        return ChangeNotifications.collapse(notifications, identityComparator);
                    }
                });
            }
        };
    }

    public static <T> Observable.Transformer<List<List<ChangeNotification<T>>>, List<ChangeNotification<T>>> collapseLists(final Comparator<T> identityComparator) {
        return new Observable.Transformer<List<List<ChangeNotification<T>>>, List<ChangeNotification<T>>>(){

            public Observable<List<ChangeNotification<T>>> call(Observable<List<List<ChangeNotification<T>>>> listOfListObservable) {
                return listOfListObservable.map(new Func1<List<List<ChangeNotification<T>>>, List<ChangeNotification<T>>>(){

                    public List<ChangeNotification<T>> call(List<List<ChangeNotification<T>>> notificationLists) {
                        TreeMap markers = new TreeMap(identityComparator);
                        ArrayList result = new ArrayList();
                        for (int i = notificationLists.size() - 1; i >= 0; --i) {
                            ChangeNotifications.collapse(notificationLists.get(i), markers, result);
                        }
                        Collections.reverse(result);
                        return result;
                    }
                });
            }
        };
    }

    public static <T> Observable.Transformer<List<ChangeNotification<T>>, List<ChangeNotification<T>>> aggregateChanges(final Comparator<T> identityComparator, final long interval, final TimeUnit timeUnit, final Scheduler scheduler) {
        return new Observable.Transformer<List<ChangeNotification<T>>, List<ChangeNotification<T>>>(){

            public Observable<List<ChangeNotification<T>>> call(Observable<List<ChangeNotification<T>>> batchUpdates) {
                return batchUpdates.buffer(interval, timeUnit, scheduler).compose(ChangeNotifications.collapseLists(identityComparator));
            }
        };
    }

    public static <T> Observable.Transformer<List<ChangeNotification<T>>, List<ChangeNotification<T>>> emitAndAggregateChanges(final Comparator<T> identityComparator, final long interval, final TimeUnit timeUnit, final Scheduler scheduler) {
        return new Observable.Transformer<List<ChangeNotification<T>>, List<ChangeNotification<T>>>(){

            public Observable<List<ChangeNotification<T>>> call(Observable<List<ChangeNotification<T>>> batchUpdates) {
                return batchUpdates.buffer(Observable.timer((long)0L, (long)interval, (TimeUnit)timeUnit, (Scheduler)scheduler)).compose(ChangeNotifications.collapseLists(identityComparator));
            }
        };
    }

    public static <T> Observable.Transformer<List<ChangeNotification<T>>, List<ChangeNotification<T>>> emitAndAggregateChanges(Comparator<T> identityComparator, long interval, TimeUnit timeUnit) {
        return ChangeNotifications.emitAndAggregateChanges(identityComparator, interval, timeUnit, Schedulers.computation());
    }

    private static <T> List<ChangeNotification<T>> collapse(List<ChangeNotification<T>> notifications, Comparator<T> identityComparator) {
        ArrayList<ChangeNotification<T>> result = new ArrayList<ChangeNotification<T>>();
        ChangeNotifications.collapse(notifications, new TreeMap(identityComparator), result);
        Collections.reverse(result);
        return result;
    }

    private static <T> void collapse(List<ChangeNotification<T>> notifications, Map<T, Integer> markers, List<ChangeNotification<T>> result) {
        for (int i = notifications.size() - 1; i >= 0; --i) {
            ChangeNotification<T> next = notifications.get(i);
            if (!next.isDataNotification()) continue;
            T data = next.getData();
            if (markers.keySet().contains(data)) {
                int idx = markers.get(data);
                if (next.getKind() != ChangeNotification.Kind.Add || result.get(idx).getKind() != ChangeNotification.Kind.Modify) continue;
                result.set(idx, next);
                continue;
            }
            markers.put(data, result.size());
            result.add(next);
        }
    }
}

