/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.interests;

import com.netflix.eureka2.interests.Interest;
import java.util.HashSet;
import java.util.Set;

public class MultipleInterests<T>
extends Interest<T> {
    private final Set<Interest<T>> interests = new HashSet<Interest<T>>();

    @SafeVarargs
    public MultipleInterests(Interest<T> ... interests) {
        for (Interest<T> interest : interests) {
            MultipleInterests.append(interest, this.interests);
        }
    }

    public MultipleInterests(Iterable<Interest<T>> interests) {
        for (Interest<T> interest : interests) {
            MultipleInterests.append(interest, this.interests);
        }
    }

    public Set<Interest<T>> getInterests() {
        return this.interests;
    }

    @Override
    public boolean matches(T data) {
        for (Interest<T> interest : this.interests) {
            if (!interest.matches(data)) continue;
            return true;
        }
        return false;
    }

    public Set<Interest<T>> flatten() {
        return new HashSet<Interest<T>>(this.interests);
    }

    public MultipleInterests<T> copyAndAppend(Interest<T> toAppend) {
        Set<Interest<T>> newInterests = this.flatten();
        MultipleInterests.append(toAppend, newInterests);
        return new MultipleInterests<T>(newInterests);
    }

    public MultipleInterests<T> copyAndRemove(Interest<T> toAppend) {
        Set<Interest<T>> newInterests = this.flatten();
        MultipleInterests.remove(toAppend, newInterests);
        return new MultipleInterests<T>(newInterests);
    }

    private static <T> void append(Interest<T> interest, Set<Interest<T>> collector) {
        if (interest instanceof MultipleInterests) {
            for (Interest<T> i : ((MultipleInterests)interest).getInterests()) {
                MultipleInterests.append(i, collector);
            }
        } else {
            collector.add(interest);
        }
    }

    private static <T> void remove(Interest<T> interest, Set<Interest<T>> collector) {
        if (interest instanceof MultipleInterests) {
            for (Interest<T> i : ((MultipleInterests)interest).getInterests()) {
                MultipleInterests.remove(i, collector);
            }
        } else {
            collector.remove(interest);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultipleInterests)) {
            return false;
        }
        MultipleInterests that = (MultipleInterests)o;
        return this.interests.equals(that.interests);
    }

    public int hashCode() {
        return this.interests.hashCode();
    }

    public String toString() {
        return "MultipleInterests{interests=" + this.interests + '}';
    }
}

