/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.interests;

import com.netflix.eureka2.interests.ChangeNotification;
import com.netflix.eureka2.interests.Interest;
import com.netflix.eureka2.utils.Asserts;

public class StreamStateNotification<T>
extends ChangeNotification<T> {
    private final BufferState bufferState;
    private final Interest<T> interest;

    public StreamStateNotification(BufferState bufferState, Interest<T> interest) {
        super(ChangeNotification.Kind.BufferSentinel, null);
        Asserts.assertNonNull(bufferState, "batchingState");
        Asserts.assertNonNull(interest, "interest");
        this.bufferState = bufferState;
        this.interest = interest;
    }

    public BufferState getBufferState() {
        return this.bufferState;
    }

    public Interest<T> getInterest() {
        return this.interest;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StreamStateNotification that = (StreamStateNotification)o;
        if (this.bufferState != that.bufferState) {
            return false;
        }
        return this.interest.equals(that.interest);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.bufferState.hashCode();
        result = 31 * result + this.interest.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "StreamStateNotification{batchingState=" + (Object)((Object)this.bufferState) + ", interest=" + this.interest + '}';
    }

    public static <T> StreamStateNotification<T> bufferStartNotification(Interest<T> interest) {
        return new StreamStateNotification<T>(BufferState.BufferStart, interest);
    }

    public static <T> StreamStateNotification<T> bufferEndNotification(Interest<T> interest) {
        return new StreamStateNotification<T>(BufferState.BufferEnd, interest);
    }

    public static enum BufferState {
        Unknown,
        BufferStart,
        BufferEnd;

    }
}

