/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.metric.server;

import com.netflix.eureka2.interests.ApplicationInterest;
import com.netflix.eureka2.interests.FullRegistryInterest;
import com.netflix.eureka2.interests.InstanceInterest;
import com.netflix.eureka2.interests.Interest;
import com.netflix.eureka2.interests.MultipleInterests;
import com.netflix.eureka2.interests.VipInterest;
import com.netflix.eureka2.metric.InterestChannelMetrics;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public interface ServerInterestChannelMetrics
extends InterestChannelMetrics {
    public void incrementApplicationNotificationCounter(String var1);

    public void incrementSubscriptionCounter(AtomicInterest var1, String var2);

    public void decrementSubscriptionCounter(AtomicInterest var1, String var2);

    public static class ChannelSubscriptionMonitor {
        private final ServerInterestChannelMetrics metrics;
        private Set<String> applications = new HashSet<String>();
        private Set<String> vips = new HashSet<String>();
        private Set<String> instances = new HashSet<String>();
        private boolean fullRegistry;

        public ChannelSubscriptionMonitor(ServerInterestChannelMetrics metrics) {
            this.metrics = metrics;
        }

        public void update(Interest<InstanceInfo> newInterests) {
            HashSet<String> newApplications = new HashSet<String>();
            HashSet<String> newVips = new HashSet<String>();
            HashSet<String> newInstances = new HashSet<String>();
            boolean newFullRegistry = false;
            for (Interest<InstanceInfo> basicInterest : this.getBasicInterests(newInterests)) {
                if (basicInterest instanceof InstanceInterest) {
                    newInstances.add(((InstanceInterest)basicInterest).getPattern());
                    continue;
                }
                if (basicInterest instanceof ApplicationInterest) {
                    newApplications.add(((ApplicationInterest)basicInterest).getPattern());
                    continue;
                }
                if (basicInterest instanceof VipInterest) {
                    newVips.add(((VipInterest)basicInterest).getPattern());
                    continue;
                }
                if (!(basicInterest instanceof FullRegistryInterest)) continue;
                newFullRegistry = true;
            }
            for (String app : newApplications) {
                if (this.applications.contains(app)) continue;
                this.metrics.incrementSubscriptionCounter(AtomicInterest.Application, app);
            }
            for (String app : this.applications) {
                if (newApplications.contains(app)) continue;
                this.metrics.decrementSubscriptionCounter(AtomicInterest.Application, app);
            }
            this.applications = newApplications;
            for (String vip : newVips) {
                if (this.vips.contains(vip)) continue;
                this.metrics.incrementSubscriptionCounter(AtomicInterest.Vip, vip);
            }
            for (String vip : this.vips) {
                if (newVips.contains(vip)) continue;
                this.metrics.decrementSubscriptionCounter(AtomicInterest.Vip, vip);
            }
            this.vips = newVips;
            for (String instance : newInstances) {
                if (this.instances.contains(instance)) continue;
                this.metrics.incrementSubscriptionCounter(AtomicInterest.Instance, instance);
            }
            for (String instance : this.instances) {
                if (newInstances.contains(instance)) continue;
                this.metrics.decrementSubscriptionCounter(AtomicInterest.Instance, instance);
            }
            this.instances = newInstances;
            if (this.fullRegistry) {
                if (!newFullRegistry) {
                    this.metrics.decrementSubscriptionCounter(AtomicInterest.InterestAll, null);
                }
            } else if (newFullRegistry) {
                this.metrics.incrementSubscriptionCounter(AtomicInterest.InterestAll, null);
            }
            this.fullRegistry = newFullRegistry;
        }

        protected Set<Interest<InstanceInfo>> getBasicInterests(Interest<InstanceInfo> newInterests) {
            Set<Interest<InstanceInfo>> basicInterests = newInterests instanceof MultipleInterests ? ((MultipleInterests)newInterests).flatten() : Collections.singleton(newInterests);
            return basicInterests;
        }
    }

    public static enum AtomicInterest {
        Instance,
        Application,
        Vip,
        InterestAll;

    }
}

