/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry;

import com.netflix.eureka2.interests.ChangeNotification;
import com.netflix.eureka2.interests.SourcedChangeNotification;
import com.netflix.eureka2.registry.Source;
import java.util.Collection;
import rx.Observable;

public interface MultiSourcedDataHolder<V> {
    public String getId();

    public int size();

    public V get();

    public V get(Source var1);

    public Source getSource();

    public Collection<Source> getAllSources();

    public SourcedChangeNotification<V> getChangeNotification();

    public Observable<Status> update(Source var1, V var2);

    public Observable<Status> remove(Source var1);

    public static interface HolderStoreAccessor<E extends MultiSourcedDataHolder> {
        public void add(E var1);

        public E get(String var1);

        public void remove(String var1);

        public boolean contains(String var1);
    }

    public static final class Snapshot<V> {
        private final SourcedChangeNotification<V> notification;

        protected Snapshot(Source source, V data) {
            this.notification = new SourcedChangeNotification<V>(ChangeNotification.Kind.Add, data, source);
        }

        Source getSource() {
            return this.notification.getSource();
        }

        V getData() {
            return (V)this.notification.getData();
        }

        SourcedChangeNotification<V> getNotification() {
            return this.notification;
        }
    }

    public static enum Status {
        AddedFirst,
        AddedChange,
        AddExpired,
        RemovedFragment,
        RemovedLast,
        RemoveExpired;

    }
}

