/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry;

import com.netflix.eureka2.interests.ChangeNotification;
import com.netflix.eureka2.interests.SourcedChangeNotification;
import com.netflix.eureka2.interests.SourcedModifyNotification;
import com.netflix.eureka2.metric.SerializedTaskInvokerMetrics;
import com.netflix.eureka2.registry.MultiSourcedDataHolder;
import com.netflix.eureka2.registry.Source;
import com.netflix.eureka2.registry.instance.Delta;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import com.netflix.eureka2.utils.SerializedTaskInvoker;
import com.netflix.eureka2.utils.rx.PauseableSubject;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Action1;

public class NotifyingInstanceInfoHolder
implements MultiSourcedDataHolder<InstanceInfo> {
    private static final Logger logger = LoggerFactory.getLogger(NotifyingInstanceInfoHolder.class);
    private final PauseableSubject<ChangeNotification<InstanceInfo>> pauseableSubject;
    private final MultiSourcedDataHolder.HolderStoreAccessor<NotifyingInstanceInfoHolder> holderStoreAccessor;
    private final DataStore dataStore;
    private final NotificationTaskInvoker invoker;
    private final String id;
    private MultiSourcedDataHolder.Snapshot<InstanceInfo> snapshot;

    public NotifyingInstanceInfoHolder(MultiSourcedDataHolder.HolderStoreAccessor<NotifyingInstanceInfoHolder> holderStoreAccessor, PauseableSubject<ChangeNotification<InstanceInfo>> pauseableSubject, NotificationTaskInvoker invoker, String id) {
        this.holderStoreAccessor = holderStoreAccessor;
        this.pauseableSubject = pauseableSubject;
        this.invoker = invoker;
        this.id = id;
        this.dataStore = new DataStore();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int size() {
        return this.dataStore.size();
    }

    @Override
    public InstanceInfo get() {
        if (this.snapshot != null) {
            return this.snapshot.getData();
        }
        return null;
    }

    @Override
    public InstanceInfo get(Source source) {
        return this.dataStore.getExact(source);
    }

    @Override
    public Source getSource() {
        if (this.snapshot != null) {
            return this.snapshot.getSource();
        }
        return null;
    }

    @Override
    public SourcedChangeNotification<InstanceInfo> getChangeNotification() {
        if (this.snapshot != null) {
            return this.snapshot.getNotification();
        }
        return null;
    }

    @Override
    public Collection<Source> getAllSources() {
        return this.dataStore.getAllSources();
    }

    @Override
    public Observable<MultiSourcedDataHolder.Status> update(final Source source, final InstanceInfo data) {
        return this.invoker.submitTask(new Callable<Observable<MultiSourcedDataHolder.Status>>(){

            @Override
            public Observable<MultiSourcedDataHolder.Status> call() throws Exception {
                MultiSourcedDataHolder.Status status = NotifyingInstanceInfoHolder.this.doUpdate(source, data);
                return Observable.just((Object)((Object)status));
            }

            public String toString() {
                return "NotifyingInstanceInfoHolder - Update: " + data;
            }
        }).doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                logger.error("Error updating instance copy");
            }
        });
    }

    protected MultiSourcedDataHolder.Status doUpdate(Source source, InstanceInfo data) {
        NotifyingInstanceInfoHolder existing = this.holderStoreAccessor.get(this.id);
        if (existing == null) {
            this.holderStoreAccessor.add(this);
        } else if (existing != this) {
            return existing.doUpdate(source, data);
        }
        this.dataStore.put(source, data);
        MultiSourcedDataHolder.Snapshot<InstanceInfo> currSnapshot = this.snapshot;
        MultiSourcedDataHolder.Snapshot<InstanceInfo> newSnapshot = new MultiSourcedDataHolder.Snapshot<InstanceInfo>(source, data);
        MultiSourcedDataHolder.Status result = MultiSourcedDataHolder.Status.AddedChange;
        if (currSnapshot == null) {
            this.snapshot = newSnapshot;
            this.pauseableSubject.onNext(newSnapshot.getNotification());
            result = MultiSourcedDataHolder.Status.AddedFirst;
        } else if (currSnapshot.getSource().getOrigin() != Source.Origin.LOCAL && source.getOrigin() == Source.Origin.LOCAL) {
            this.snapshot = newSnapshot;
            this.pauseableSubject.onNext(newSnapshot.getNotification());
        } else if (this.matches(currSnapshot.getSource(), newSnapshot.getSource())) {
            this.snapshot = newSnapshot;
            Set<Delta<?>> delta = newSnapshot.getData().diffOlder(currSnapshot.getData());
            if (!delta.isEmpty()) {
                SourcedModifyNotification<InstanceInfo> modifyNotification = new SourcedModifyNotification<InstanceInfo>(newSnapshot.getData(), delta, newSnapshot.getSource());
                this.pauseableSubject.onNext(modifyNotification);
            } else {
                logger.debug("No-change update for {}#{}", (Object)currSnapshot.getSource(), (Object)currSnapshot.getData().getId());
            }
        } else {
            logger.debug("Different source from current snapshot, not updating (head={}, received={})", (Object)currSnapshot.getSource(), (Object)newSnapshot.getSource());
        }
        logger.debug("CHANGE result: {}, data: {}", (Object)result, (Object)data);
        return result;
    }

    @Override
    public Observable<MultiSourcedDataHolder.Status> remove(final Source source) {
        return this.invoker.submitTask(new Callable<Observable<MultiSourcedDataHolder.Status>>(){

            @Override
            public Observable<MultiSourcedDataHolder.Status> call() throws Exception {
                MultiSourcedDataHolder.Status status = NotifyingInstanceInfoHolder.this.doRemove(source);
                return Observable.just((Object)((Object)status));
            }

            public String toString() {
                return "NotifyingInstanceInfoHolder - Remove All For Source: " + source;
            }
        }).doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                logger.error("Error removing instance copy");
            }
        });
    }

    private MultiSourcedDataHolder.Status doRemove(Source source) {
        InstanceInfo removed = this.dataStore.remove(source);
        MultiSourcedDataHolder.Snapshot<InstanceInfo> currSnapshot = this.snapshot;
        MultiSourcedDataHolder.Status result = MultiSourcedDataHolder.Status.RemovedFragment;
        if (removed == null) {
            logger.debug("source:data does not exist, no-op");
            result = MultiSourcedDataHolder.Status.RemoveExpired;
        } else if (this.matches(source, currSnapshot.getSource())) {
            Map.Entry<Source, InstanceInfo> newHead = this.dataStore.nextEntry();
            if (newHead == null) {
                this.snapshot = null;
                SourcedChangeNotification<InstanceInfo> deleteNotification = new SourcedChangeNotification<InstanceInfo>(ChangeNotification.Kind.Delete, removed, source);
                this.pauseableSubject.onNext(deleteNotification);
                this.holderStoreAccessor.remove(this.id);
                result = MultiSourcedDataHolder.Status.RemovedLast;
            } else {
                MultiSourcedDataHolder.Snapshot<InstanceInfo> newSnapshot = new MultiSourcedDataHolder.Snapshot<InstanceInfo>(newHead.getKey(), newHead.getValue());
                this.snapshot = newSnapshot;
                if (source.getOrigin() == Source.Origin.LOCAL && this.snapshot.getSource().getOrigin() != Source.Origin.LOCAL) {
                    SourcedChangeNotification<InstanceInfo> deleteNotification = new SourcedChangeNotification<InstanceInfo>(ChangeNotification.Kind.Delete, removed, source);
                    this.pauseableSubject.onNext(deleteNotification);
                    SourcedChangeNotification<InstanceInfo> addNotification = new SourcedChangeNotification<InstanceInfo>(ChangeNotification.Kind.Add, this.snapshot.getData(), this.snapshot.getSource());
                    this.pauseableSubject.onNext(addNotification);
                } else {
                    Set<Delta<?>> delta = newSnapshot.getData().diffOlder(currSnapshot.getData());
                    if (!delta.isEmpty()) {
                        SourcedModifyNotification<InstanceInfo> modifyNotification = new SourcedModifyNotification<InstanceInfo>(newSnapshot.getData(), delta, newSnapshot.getSource());
                        this.pauseableSubject.onNext(modifyNotification);
                    } else {
                        logger.debug("No-change update for {}#{}", (Object)currSnapshot.getSource(), (Object)currSnapshot.getData().getId());
                    }
                }
            }
        } else {
            logger.debug("removed non-head (head={}, received={})", (Object)currSnapshot.getSource(), (Object)source);
        }
        logger.debug("REMOVE result: {}, source: {}", (Object)result, (Object)source);
        return result;
    }

    public String toString() {
        return "NotifyingInstanceInfoHolder{pauseableSubject=" + this.pauseableSubject + ", dataStore=" + this.dataStore + ", id='" + this.id + '\'' + ", snapshot=" + this.snapshot + "} " + super.toString();
    }

    private boolean matches(Source one, Source two) {
        if (one != null && two != null) {
            boolean originMatches;
            boolean bl = originMatches = one.getOrigin() == two.getOrigin();
            boolean nameMatches = one.getName() == null ? two.getName() == null : one.getName().equals(two.getName());
            return originMatches && nameMatches;
        }
        return one == null && two == null;
    }

    static class DataStore {
        protected final Map<String, Source> sourceMap = new HashMap<String, Source>();
        protected final LinkedHashMap<Source, InstanceInfo> dataMap = new LinkedHashMap();

        DataStore() {
        }

        public void put(Source source, InstanceInfo instanceInfo) {
            String sourceKey = this.sourceKey(source);
            Source currIfExist = this.sourceMap.get(sourceKey);
            if (currIfExist != null) {
                this.dataMap.remove(currIfExist);
            }
            this.dataMap.put(source, instanceInfo);
            this.sourceMap.put(sourceKey, source);
        }

        public Collection<Source> getAllSources() {
            return this.sourceMap.values();
        }

        public InstanceInfo getMatching(Source source) {
            Source currIfExist = this.getMatchingSource(source);
            if (currIfExist != null) {
                return this.dataMap.get(currIfExist);
            }
            return null;
        }

        public InstanceInfo getExact(Source source) {
            return this.dataMap.get(source);
        }

        public InstanceInfo remove(Source source) {
            String sourceKey = this.sourceKey(source);
            Source currIfExist = this.sourceMap.get(sourceKey);
            if (currIfExist != null) {
                if (currIfExist.getId().equals(source.getId())) {
                    this.sourceMap.remove(sourceKey);
                    return (InstanceInfo)this.dataMap.remove(currIfExist);
                }
                return null;
            }
            return null;
        }

        public int size() {
            return this.dataMap.size();
        }

        public Map.Entry<Source, InstanceInfo> nextEntry() {
            if (this.dataMap.isEmpty()) {
                return null;
            }
            return this.dataMap.entrySet().iterator().next();
        }

        private Source getMatchingSource(Source source) {
            String key = this.sourceKey(source);
            return this.sourceMap.get(key);
        }

        private String sourceKey(Source source) {
            return source.getOrigin().name() + source.getName();
        }
    }

    static class NotificationTaskInvoker
    extends SerializedTaskInvoker {
        NotificationTaskInvoker(SerializedTaskInvokerMetrics metrics, Scheduler scheduler) {
            super(metrics, scheduler);
        }

        Observable<MultiSourcedDataHolder.Status> submitTask(Callable<Observable<MultiSourcedDataHolder.Status>> task) {
            return this.submitForResult(task);
        }

        @Override
        public void shutdown() {
            super.shutdown();
        }
    }
}

