/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry;

import com.netflix.eureka2.interests.ChangeNotification;
import com.netflix.eureka2.interests.IndexRegistry;
import com.netflix.eureka2.interests.IndexRegistryImpl;
import com.netflix.eureka2.interests.InstanceInfoInitStateHolder;
import com.netflix.eureka2.interests.Interest;
import com.netflix.eureka2.interests.MultipleInterests;
import com.netflix.eureka2.interests.SourcedChangeNotification;
import com.netflix.eureka2.interests.StreamStateNotification;
import com.netflix.eureka2.metric.EurekaRegistryMetricFactory;
import com.netflix.eureka2.metric.EurekaRegistryMetrics;
import com.netflix.eureka2.registry.MultiSourcedDataHolder;
import com.netflix.eureka2.registry.NotifyingInstanceInfoHolder;
import com.netflix.eureka2.registry.Source;
import com.netflix.eureka2.registry.Sourced;
import com.netflix.eureka2.registry.SourcedEurekaRegistry;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import com.netflix.eureka2.utils.rx.NoOpSubscriber;
import com.netflix.eureka2.utils.rx.PauseableSubject;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.schedulers.Schedulers;
import rx.subjects.AsyncSubject;

public class SourcedEurekaRegistryImpl
implements SourcedEurekaRegistry<InstanceInfo> {
    private static final Logger logger = LoggerFactory.getLogger(SourcedEurekaRegistryImpl.class);
    protected final ConcurrentHashMap<String, NotifyingInstanceInfoHolder> internalStore;
    private final MultiSourcedDataHolder.HolderStoreAccessor<NotifyingInstanceInfoHolder> internalStoreAccessor;
    private final PauseableSubject<ChangeNotification<InstanceInfo>> pauseableSubject;
    private final IndexRegistry<InstanceInfo> indexRegistry;
    private final EurekaRegistryMetrics metrics;
    private final NotifyingInstanceInfoHolder.NotificationTaskInvoker invoker;

    public SourcedEurekaRegistryImpl(EurekaRegistryMetricFactory metricsFactory) {
        this(new IndexRegistryImpl<InstanceInfo>(), metricsFactory, Schedulers.computation());
    }

    public SourcedEurekaRegistryImpl(EurekaRegistryMetricFactory metricsFactory, Scheduler scheduler) {
        this(new IndexRegistryImpl<InstanceInfo>(), metricsFactory, scheduler);
    }

    @Inject
    public SourcedEurekaRegistryImpl(IndexRegistry indexRegistry, EurekaRegistryMetricFactory metricsFactory) {
        this(indexRegistry, metricsFactory, Schedulers.computation());
    }

    public SourcedEurekaRegistryImpl(IndexRegistry<InstanceInfo> indexRegistry, EurekaRegistryMetricFactory metricsFactory, Scheduler scheduler) {
        this.indexRegistry = indexRegistry;
        this.metrics = metricsFactory.getEurekaServerRegistryMetrics();
        this.invoker = new NotifyingInstanceInfoHolder.NotificationTaskInvoker(metricsFactory.getRegistryTaskInvokerMetrics(), scheduler);
        this.internalStore = new ConcurrentHashMap();
        this.pauseableSubject = PauseableSubject.create();
        this.internalStoreAccessor = new MultiSourcedDataHolder.HolderStoreAccessor<NotifyingInstanceInfoHolder>(){

            @Override
            public void add(NotifyingInstanceInfoHolder holder) {
                SourcedEurekaRegistryImpl.this.internalStore.put(holder.getId(), holder);
                SourcedEurekaRegistryImpl.this.metrics.setRegistrySize(SourcedEurekaRegistryImpl.this.internalStore.size());
            }

            @Override
            public NotifyingInstanceInfoHolder get(String id) {
                return SourcedEurekaRegistryImpl.this.internalStore.get(id);
            }

            @Override
            public void remove(String id) {
                SourcedEurekaRegistryImpl.this.internalStore.remove(id);
                SourcedEurekaRegistryImpl.this.metrics.setRegistrySize(SourcedEurekaRegistryImpl.this.internalStore.size());
            }

            @Override
            public boolean contains(String id) {
                return SourcedEurekaRegistryImpl.this.internalStore.containsKey(id);
            }
        };
    }

    @Override
    public Observable<Boolean> register(InstanceInfo instanceInfo, final Source source) {
        NotifyingInstanceInfoHolder holder = new NotifyingInstanceInfoHolder(this.internalStoreAccessor, this.pauseableSubject, this.invoker, instanceInfo.getId());
        Observable result = holder.update(source, instanceInfo).doOnNext((Action1)new Action1<MultiSourcedDataHolder.Status>(){

            public void call(MultiSourcedDataHolder.Status status) {
                if (status != MultiSourcedDataHolder.Status.AddExpired) {
                    SourcedEurekaRegistryImpl.this.metrics.incrementRegistrationCounter(source.getOrigin());
                }
            }
        });
        return SourcedEurekaRegistryImpl.subscribeToUpdateResult((Observable<MultiSourcedDataHolder.Status>)result);
    }

    @Override
    public Observable<Boolean> unregister(InstanceInfo instanceInfo, final Source source) {
        MultiSourcedDataHolder currentHolder = this.internalStore.get(instanceInfo.getId());
        if (currentHolder == null) {
            return Observable.just((Object)false);
        }
        Observable result = currentHolder.remove(source).doOnNext((Action1)new Action1<MultiSourcedDataHolder.Status>(){

            public void call(MultiSourcedDataHolder.Status status) {
                if (status != MultiSourcedDataHolder.Status.RemoveExpired) {
                    SourcedEurekaRegistryImpl.this.metrics.incrementUnregistrationCounter(source.getOrigin());
                }
            }
        });
        return SourcedEurekaRegistryImpl.subscribeToUpdateResult((Observable<MultiSourcedDataHolder.Status>)result);
    }

    private static Observable<Boolean> subscribeToUpdateResult(Observable<MultiSourcedDataHolder.Status> status) {
        AsyncSubject result = AsyncSubject.create();
        status.take(1).onBackpressureBuffer(1L).map((Func1)new Func1<MultiSourcedDataHolder.Status, Boolean>(){

            public Boolean call(MultiSourcedDataHolder.Status status) {
                logger.debug("Registry updated completed with status {}", (Object)status);
                if (status.equals((Object)MultiSourcedDataHolder.Status.AddedFirst) || status.equals((Object)MultiSourcedDataHolder.Status.RemovedLast)) {
                    return true;
                }
                return false;
            }
        }).doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable e) {
                logger.error("Registry update failure", e);
                e.printStackTrace();
            }
        }).subscribe((Observer)result);
        return result;
    }

    @Override
    public int size() {
        return this.internalStore.size();
    }

    @Override
    public Observable<InstanceInfo> forSnapshot(final Interest<InstanceInfo> interest) {
        return Observable.from(this.internalStore.values()).map((Func1)new Func1<MultiSourcedDataHolder<InstanceInfo>, InstanceInfo>(){

            public InstanceInfo call(MultiSourcedDataHolder<InstanceInfo> holder) {
                SourcedChangeNotification<InstanceInfo> notification = holder.getChangeNotification();
                return notification == null ? null : (InstanceInfo)notification.getData();
            }
        }).filter((Func1)new Func1<InstanceInfo, Boolean>(){

            public Boolean call(InstanceInfo instanceInfo) {
                return instanceInfo != null && interest.matches(instanceInfo);
            }
        });
    }

    @Override
    public Observable<InstanceInfo> forSnapshot(Interest<InstanceInfo> interest, final Source.SourceMatcher sourceMatcher) {
        return this.forSnapshot(interest).filter((Func1)new Func1<InstanceInfo, Boolean>(){

            public Boolean call(InstanceInfo instanceInfo) {
                MultiSourcedDataHolder holder = SourcedEurekaRegistryImpl.this.internalStore.get(instanceInfo.getId());
                return holder != null && sourceMatcher.match(holder.getSource());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Observable<ChangeNotification<InstanceInfo>> forInterest(Interest<InstanceInfo> interest) {
        try {
            this.pauseableSubject.pause();
            if (interest instanceof MultipleInterests) {
                Observable<ChangeNotification<InstanceInfo>> observable = this.indexRegistry.forCompositeInterest((MultipleInterests)interest, this);
                return observable;
            }
            Observable<ChangeNotification<InstanceInfo>> observable = this.indexRegistry.forInterest(interest, (Observable<ChangeNotification<InstanceInfo>>)this.pauseableSubject, new InstanceInfoInitStateHolder(this.getSnapshotForInterest(interest), interest));
            return observable;
        }
        finally {
            this.pauseableSubject.resume();
        }
    }

    @Override
    public Observable<ChangeNotification<InstanceInfo>> forInterest(Interest<InstanceInfo> interest, final Source.SourceMatcher sourceMatcher) {
        return this.forInterest(interest).filter((Func1)new Func1<ChangeNotification<InstanceInfo>, Boolean>(){

            public Boolean call(ChangeNotification<InstanceInfo> changeNotification) {
                if (changeNotification instanceof Sourced) {
                    Source notificationSource = ((Sourced)((Object)changeNotification)).getSource();
                    return sourceMatcher.match(notificationSource);
                }
                if (changeNotification instanceof StreamStateNotification) {
                    return false;
                }
                logger.warn("Received notification without a source, {}", changeNotification);
                return false;
            }
        });
    }

    @Override
    public Observable<Long> evictAllExcept(final Source.SourceMatcher retainMatcher) {
        return this.getHolders().doOnNext((Action1)new Action1<MultiSourcedDataHolder<InstanceInfo>>(){

            public void call(MultiSourcedDataHolder<InstanceInfo> holder) {
                for (Source source : holder.getAllSources()) {
                    if (retainMatcher.match(source)) continue;
                    holder.remove(source).subscribe(new NoOpSubscriber());
                }
            }
        }).countLong().doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                logger.error("Error evicting registry", throwable);
            }
        }).doOnCompleted(new Action0(){

            public void call() {
                logger.info("Completed evicting registry");
            }
        });
    }

    @Override
    public Observable<? extends MultiSourcedDataHolder<InstanceInfo>> getHolders() {
        return Observable.from(this.internalStore.values());
    }

    @Override
    public Observable<Void> shutdown() {
        logger.info("Shutting down the eureka registry");
        this.invoker.shutdown();
        this.pauseableSubject.onCompleted();
        this.internalStore.clear();
        return this.indexRegistry.shutdown();
    }

    @Override
    public Observable<Void> shutdown(Throwable cause) {
        this.invoker.shutdown();
        this.pauseableSubject.onCompleted();
        return this.indexRegistry.shutdown(cause);
    }

    private Iterator<ChangeNotification<InstanceInfo>> getSnapshotForInterest(Interest<InstanceInfo> interest) {
        Collection<NotifyingInstanceInfoHolder> eurekaHolders = this.internalStore.values();
        return new FilteredIterator(interest, eurekaHolders.iterator());
    }

    public String toString() {
        return this.prettyString();
    }

    private String prettyString() {
        StringBuilder sb = new StringBuilder("EurekaRegistryImpl\n");
        for (Map.Entry<String, NotifyingInstanceInfoHolder> entry : this.internalStore.entrySet()) {
            sb.append(entry).append("\n");
        }
        sb.append(this.indexRegistry.toString());
        return sb.toString();
    }

    private static class FilteredIterator
    implements Iterator<ChangeNotification<InstanceInfo>> {
        private final Interest<InstanceInfo> interest;
        private final Iterator<NotifyingInstanceInfoHolder> delegate;
        private ChangeNotification<InstanceInfo> next;

        private FilteredIterator(Interest<InstanceInfo> interest, Iterator<NotifyingInstanceInfoHolder> delegate) {
            this.interest = interest;
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            if (null != this.next) {
                return true;
            }
            while (this.delegate.hasNext()) {
                MultiSourcedDataHolder possibleNext = this.delegate.next();
                SourcedChangeNotification notification = possibleNext.getChangeNotification();
                if (notification == null || !this.interest.matches((InstanceInfo)notification.getData())) continue;
                this.next = notification;
                return true;
            }
            return false;
        }

        @Override
        public ChangeNotification<InstanceInfo> next() {
            if (this.hasNext()) {
                ChangeNotification<InstanceInfo> next = this.next;
                this.next = null;
                return next;
            }
            throw new NoSuchElementException("No more notifications.");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported for this iterator.");
        }
    }
}

