/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry.datacenter;

import com.netflix.eureka2.registry.datacenter.DataCenterInfo;
import com.netflix.eureka2.registry.instance.NetworkAddress;
import java.util.ArrayList;
import java.util.List;

public class AwsDataCenterInfo
extends DataCenterInfo {
    private final String name;
    private final String region;
    private final String zone;
    private final String placementGroup;
    private final String amiId;
    private final String instanceId;
    private final String instanceType;
    private final String eth0mac;
    private final String vpcId;
    private final String accountId;
    private final NetworkAddress publicAddress;
    private final NetworkAddress privateAddress;

    private AwsDataCenterInfo() {
        this.accountId = null;
        this.vpcId = null;
        this.eth0mac = null;
        this.instanceType = null;
        this.instanceId = null;
        this.amiId = null;
        this.placementGroup = null;
        this.zone = null;
        this.region = null;
        this.name = null;
        this.privateAddress = null;
        this.publicAddress = null;
    }

    private AwsDataCenterInfo(Builder builder) {
        this.region = builder.region;
        this.zone = builder.zone;
        this.placementGroup = builder.placementGroup;
        this.amiId = builder.amiId;
        this.name = this.instanceId = builder.instanceId;
        this.instanceType = builder.instanceType;
        this.eth0mac = builder.eth0mac;
        this.vpcId = builder.vpcId;
        this.accountId = builder.accountId;
        this.privateAddress = builder.privateIP != null || builder.privateHostName != null ? NetworkAddress.NetworkAddressBuilder.aNetworkAddress().withLabel("private").withProtocolType(NetworkAddress.ProtocolType.IPv4).withHostName(builder.privateHostName).withIpAddress(builder.privateIP).build() : null;
        this.publicAddress = builder.publicIP != null || builder.publicHostName != null ? NetworkAddress.NetworkAddressBuilder.aNetworkAddress().withLabel("public").withProtocolType(NetworkAddress.ProtocolType.IPv4).withHostName(builder.publicHostName).withIpAddress(builder.publicIP).build() : null;
    }

    public String getRegion() {
        return this.region;
    }

    public String getZone() {
        return this.zone;
    }

    public String getPlacementGroup() {
        return this.placementGroup;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<NetworkAddress> getAddresses() {
        ArrayList<NetworkAddress> addresses = new ArrayList<NetworkAddress>(2);
        if (this.publicAddress != null) {
            addresses.add(this.publicAddress);
        }
        if (this.privateAddress != null) {
            addresses.add(this.privateAddress);
        }
        return addresses;
    }

    @Override
    public NetworkAddress getDefaultAddress() {
        return this.publicAddress != null ? this.publicAddress : this.privateAddress;
    }

    public NetworkAddress getPublicAddress() {
        return this.publicAddress;
    }

    public NetworkAddress getPrivateAddress() {
        return this.privateAddress;
    }

    public String getAmiId() {
        return this.amiId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getEth0mac() {
        return this.eth0mac;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AwsDataCenterInfo)) {
            return false;
        }
        AwsDataCenterInfo that = (AwsDataCenterInfo)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.amiId != null ? !this.amiId.equals(that.amiId) : that.amiId != null) {
            return false;
        }
        if (this.eth0mac != null ? !this.eth0mac.equals(that.eth0mac) : that.eth0mac != null) {
            return false;
        }
        if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) {
            return false;
        }
        if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.placementGroup != null ? !this.placementGroup.equals(that.placementGroup) : that.placementGroup != null) {
            return false;
        }
        if (this.privateAddress != null ? !this.privateAddress.equals(that.privateAddress) : that.privateAddress != null) {
            return false;
        }
        if (this.publicAddress != null ? !this.publicAddress.equals(that.publicAddress) : that.publicAddress != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        if (this.vpcId != null ? !this.vpcId.equals(that.vpcId) : that.vpcId != null) {
            return false;
        }
        return !(this.zone != null ? !this.zone.equals(that.zone) : that.zone != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        result = 31 * result + (this.zone != null ? this.zone.hashCode() : 0);
        result = 31 * result + (this.placementGroup != null ? this.placementGroup.hashCode() : 0);
        result = 31 * result + (this.amiId != null ? this.amiId.hashCode() : 0);
        result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
        result = 31 * result + (this.eth0mac != null ? this.eth0mac.hashCode() : 0);
        result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.publicAddress != null ? this.publicAddress.hashCode() : 0);
        result = 31 * result + (this.privateAddress != null ? this.privateAddress.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AwsDataCenterInfo{name='" + this.name + '\'' + ", region='" + this.region + '\'' + ", zone='" + this.zone + '\'' + ", placementGroup='" + this.placementGroup + '\'' + ", amiId='" + this.amiId + '\'' + ", instanceId='" + this.instanceId + '\'' + ", instanceType='" + this.instanceType + '\'' + ", eth0mac='" + this.eth0mac + '\'' + ", vpcId='" + this.vpcId + '\'' + ", accountId='" + this.accountId + '\'' + ", publicAddress=" + this.publicAddress + ", privateAddress=" + this.privateAddress + "} " + super.toString();
    }

    public static final class Builder
    extends DataCenterInfo.DataCenterInfoBuilder<AwsDataCenterInfo> {
        private String region;
        private String zone;
        private String placementGroup;
        private String amiId;
        private String instanceId;
        private String instanceType;
        private String privateIP;
        private String privateHostName;
        private String publicIP;
        private String publicHostName;
        private String eth0mac;
        private String vpcId;
        private String accountId;

        public Builder withAwsDataCenter(AwsDataCenterInfo dataCenter) {
            this.region = dataCenter.getRegion();
            this.zone = dataCenter.getZone();
            this.placementGroup = dataCenter.getPlacementGroup();
            this.amiId = dataCenter.getAmiId();
            this.instanceId = dataCenter.getInstanceId();
            this.instanceType = dataCenter.getInstanceType();
            this.privateIP = dataCenter.getPrivateAddress().getIpAddress();
            this.privateHostName = dataCenter.getPrivateAddress().getHostName();
            this.publicIP = dataCenter.getPublicAddress().getIpAddress();
            this.publicHostName = dataCenter.getPublicAddress().getHostName();
            this.eth0mac = dataCenter.getEth0mac();
            this.vpcId = dataCenter.getVpcId();
            this.accountId = dataCenter.getAccountId();
            return this;
        }

        public Builder withRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder withZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder withPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public Builder withAmiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public Builder withInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder withInstanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder withPrivateIPv4(String privateIP) {
            this.privateIP = privateIP;
            return this;
        }

        public Builder withPrivateHostName(String privateHostName) {
            this.privateHostName = privateHostName;
            return this;
        }

        public Builder withPublicIPv4(String publicIP) {
            this.publicIP = publicIP;
            return this;
        }

        public Builder withPublicHostName(String publicHostName) {
            this.publicHostName = publicHostName;
            return this;
        }

        public Builder withVpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public Builder withAccountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder withEth0mac(String eth0mac) {
            this.eth0mac = eth0mac;
            return this;
        }

        @Override
        public AwsDataCenterInfo build() {
            if (this.region == null && this.zone != null && !this.zone.isEmpty()) {
                this.region = this.zone.substring(0, this.zone.length() - 1);
            }
            return new AwsDataCenterInfo(this);
        }
    }
}

