/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry.datacenter;

import com.eureka2.shading.reactivex.netty.RxNetty;
import com.eureka2.shading.reactivex.netty.protocol.http.client.HttpClientResponse;
import com.netflix.eureka2.registry.datacenter.AwsDataCenterInfo;
import com.netflix.eureka2.registry.datacenter.DataCenterInfoProvider;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;
import rx.subjects.AsyncSubject;

public class AwsDataCenterInfoProvider
implements DataCenterInfoProvider {
    private static final String AWS_API_VERSION = "latest/";
    private static final String AWS_METADATA_URI = "http://169.254.169.254/latest/";
    private static final String INSTANCE_DATA = "meta-data/";
    private static final String DYNAMIC_DATA = "dynamic/";
    private final String metaDataURI;
    private final AtomicReference<Observable<AwsDataCenterInfo>> dataCenterInfoRef = new AtomicReference();
    private static final Func1<HttpClientResponse<ByteBuf>, Observable<String>> EC2_METADATA_RESPONSE_FUNC = new Func1<HttpClientResponse<ByteBuf>, Observable<String>>(){

        public Observable<String> call(HttpClientResponse<ByteBuf> response) {
            if (response == null) {
                return Observable.error((Throwable)new IOException("Server returned null response"));
            }
            int responseCode = response.getStatus().code();
            if (responseCode >= 200 && responseCode <= 299) {
                return response.getContent().map((Func1)new Func1<ByteBuf, String>(){

                    public String call(ByteBuf byteBuf) {
                        return byteBuf.toString(Charset.defaultCharset());
                    }
                });
            }
            if (responseCode == 404) {
                return Observable.empty();
            }
            return Observable.error((Throwable)new IOException("Server returned error status " + response.getStatus()));
        }
    };

    public AwsDataCenterInfoProvider() {
        this.metaDataURI = AWS_METADATA_URI;
    }

    AwsDataCenterInfoProvider(String metaDataURI) {
        this.metaDataURI = metaDataURI;
    }

    public Observable<AwsDataCenterInfo> dataCenterInfo() {
        if (this.dataCenterInfoRef.get() != null) {
            return this.dataCenterInfoRef.get();
        }
        this.dataCenterInfoRef.compareAndSet(null, this.readMetaInfo());
        return this.dataCenterInfoRef.get();
    }

    private Observable<AwsDataCenterInfo> readMetaInfo() {
        final AsyncSubject subject = AsyncSubject.create();
        final AwsDataCenterInfo.Builder builder = new AwsDataCenterInfo.Builder();
        Observable.from((Object[])MetaDataKey.values()).flatMap((Func1)new Func1<MetaDataKey, Observable<MetaDataKey>>(){

            public Observable<MetaDataKey> call(final MetaDataKey key) {
                String uri;
                switch (key) {
                    case VpcId: {
                        return Observable.empty();
                    }
                    case AccountId: {
                        uri = key.finalUri(AwsDataCenterInfoProvider.this.metaDataURI, AwsDataCenterInfoProvider.DYNAMIC_DATA, new String[0]);
                        break;
                    }
                    default: {
                        uri = key.finalUri(AwsDataCenterInfoProvider.this.metaDataURI, AwsDataCenterInfoProvider.INSTANCE_DATA, new String[0]);
                    }
                }
                return RxNetty.createHttpGet(uri).flatMap(EC2_METADATA_RESPONSE_FUNC).map((Func1)new Func1<String, MetaDataKey>(){

                    public MetaDataKey call(String metaValue) {
                        key.apply(builder, metaValue);
                        return key;
                    }
                });
            }
        }).filter((Func1)new Func1<MetaDataKey, Boolean>(){

            public Boolean call(MetaDataKey metaDataKey) {
                return metaDataKey == MetaDataKey.Mac;
            }
        }).flatMap((Func1)new Func1<MetaDataKey, Observable<Void>>(){

            public Observable<Void> call(MetaDataKey macKey) {
                String vpcUri = MetaDataKey.VpcId.finalUri(AwsDataCenterInfoProvider.this.metaDataURI, AwsDataCenterInfoProvider.INSTANCE_DATA, macKey.getValue());
                return RxNetty.createHttpGet(vpcUri).flatMap(EC2_METADATA_RESPONSE_FUNC).map((Func1)new Func1<String, Void>(){

                    public Void call(String metaValue) {
                        MetaDataKey.VpcId.apply(builder, metaValue);
                        return null;
                    }
                });
            }
        }).subscribe((Subscriber)new Subscriber<Void>(){

            public void onCompleted() {
                subject.onNext((Object)builder.build());
                subject.onCompleted();
            }

            public void onError(Throwable e) {
                subject.onError(e);
            }

            public void onNext(Void aVoid) {
            }
        });
        return subject;
    }

    static enum MetaDataKey {
        AmiId("ami-id"){

            @Override
            protected AwsDataCenterInfo.Builder doApply(AwsDataCenterInfo.Builder builder, String metaInfoValue) {
                return builder.withAmiId(metaInfoValue);
            }
        }
        ,
        InstanceId("instance-id"){

            @Override
            protected AwsDataCenterInfo.Builder doApply(AwsDataCenterInfo.Builder builder, String metaInfoValue) {
                return builder.withInstanceId(metaInfoValue);
            }
        }
        ,
        InstanceType("instance-type"){

            @Override
            protected AwsDataCenterInfo.Builder doApply(AwsDataCenterInfo.Builder builder, String metaInfoValue) {
                return builder.withInstanceType(metaInfoValue);
            }
        }
        ,
        PublicHostname("public-hostname"){

            @Override
            protected AwsDataCenterInfo.Builder doApply(AwsDataCenterInfo.Builder builder, String metaInfoValue) {
                return builder.withPublicHostName(metaInfoValue);
            }
        }
        ,
        PublicIpv4("public-ipv4"){

            @Override
            protected AwsDataCenterInfo.Builder doApply(AwsDataCenterInfo.Builder builder, String metaInfoValue) {
                return builder.withPublicIPv4(metaInfoValue);
            }
        }
        ,
        LocalHostName("local-hostname"){

            @Override
            protected AwsDataCenterInfo.Builder doApply(AwsDataCenterInfo.Builder builder, String metaInfoValue) {
                return builder.withPrivateHostName(metaInfoValue);
            }
        }
        ,
        LocalIpv4("local-ipv4"){

            @Override
            protected AwsDataCenterInfo.Builder doApply(AwsDataCenterInfo.Builder builder, String metaInfoValue) {
                return builder.withPrivateIPv4(metaInfoValue);
            }
        }
        ,
        AvailabilityZone("availability-zone", "placement/"){

            @Override
            protected AwsDataCenterInfo.Builder doApply(AwsDataCenterInfo.Builder builder, String metaInfoValue) {
                return builder.withZone(metaInfoValue);
            }
        }
        ,
        Mac("mac"){

            @Override
            protected AwsDataCenterInfo.Builder doApply(AwsDataCenterInfo.Builder builder, String metaInfoValue) {
                return builder.withEth0mac(metaInfoValue);
            }
        }
        ,
        VpcId("vpc-id", "network/interfaces/macs/"){

            @Override
            public String finalUri(String metaDataUri, String metaDataType, String ... args) {
                String eth0mac = args.length == 0 ? "" : args[0];
                return metaDataUri + metaDataType + this.getPath() + eth0mac + "/" + this.getName();
            }

            @Override
            protected AwsDataCenterInfo.Builder doApply(AwsDataCenterInfo.Builder builder, String metaInfoValue) {
                return builder.withVpcId(metaInfoValue);
            }
        }
        ,
        AccountId("document", "instance-identity/"){
            private Pattern pattern = Pattern.compile("\"accountId\"\\s?:\\s?\\\"([A-Za-z0-9]*)\\\"");

            @Override
            protected AwsDataCenterInfo.Builder doApply(AwsDataCenterInfo.Builder builder, String metaInfoValue) {
                Matcher matcher = this.pattern.matcher(metaInfoValue);
                if (matcher.find()) {
                    return builder.withAccountId(matcher.group(1));
                }
                return builder.withAccountId(null);
            }
        };

        private final String name;
        private final String path;
        private String value;

        private MetaDataKey(String name) {
            this(name, "");
        }

        private MetaDataKey(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String getValue() {
            return this.value;
        }

        public String finalUri(String metaDataUri, String metaDataType, String ... args) {
            return metaDataUri + metaDataType + this.path + this.name;
        }

        public AwsDataCenterInfo.Builder apply(AwsDataCenterInfo.Builder builder, String metaInfoValue) {
            this.value = metaInfoValue;
            return this.doApply(builder, metaInfoValue);
        }

        protected abstract AwsDataCenterInfo.Builder doApply(AwsDataCenterInfo.Builder var1, String var2);
    }
}

