/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry.datacenter;

import com.netflix.eureka2.registry.datacenter.DataCenterInfo;
import com.netflix.eureka2.registry.instance.NetworkAddress;
import com.netflix.eureka2.utils.SystemUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BasicDataCenterInfo
extends DataCenterInfo {
    private final String name;
    private final List<NetworkAddress> addresses;
    private volatile NetworkAddress defaultAddress;

    private BasicDataCenterInfo() {
        this.name = null;
        this.addresses = null;
    }

    public BasicDataCenterInfo(String name, List<NetworkAddress> addresses) {
        this.name = name;
        this.addresses = addresses;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<NetworkAddress> getAddresses() {
        return this.addresses;
    }

    @Override
    public NetworkAddress getDefaultAddress() {
        if (this.defaultAddress != null) {
            return this.defaultAddress;
        }
        if (this.addresses == null || this.addresses.isEmpty()) {
            return null;
        }
        NetworkAddress best = null;
        for (NetworkAddress address : this.addresses) {
            if (best == null) {
                best = address;
                if (!best.hasLabel("public")) continue;
                break;
            }
            if (!address.hasLabel("public")) continue;
            best = address;
            break;
        }
        this.defaultAddress = best;
        return this.defaultAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicDataCenterInfo that = (BasicDataCenterInfo)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.addresses != null ? this.addresses.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BasicDataCenterInfo{name='" + this.name + '\'' + ", addresses=" + this.addresses + '}';
    }

    public static BasicDataCenterInfo fromSystemData() {
        Builder builder = new Builder();
        builder.withName(SystemUtil.getHostName());
        for (String ip : SystemUtil.getLocalIPs()) {
            if (SystemUtil.isLoopbackIP(ip)) continue;
            boolean isPublic = SystemUtil.isPublic(ip);
            NetworkAddress.ProtocolType protocol = SystemUtil.isIPv6(ip) ? NetworkAddress.ProtocolType.IPv6 : NetworkAddress.ProtocolType.IPv4;
            builder.withAddresses(NetworkAddress.NetworkAddressBuilder.aNetworkAddress().withLabel(isPublic ? "public" : "private").withProtocolType(protocol).withIpAddress(ip).build());
        }
        return builder.build();
    }

    public static class Builder<T extends BasicDataCenterInfo>
    extends DataCenterInfo.DataCenterInfoBuilder<T> {
        private String name;
        private final List<NetworkAddress> addresses = new ArrayList<NetworkAddress>();

        public Builder<T> withName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> withAddresses(NetworkAddress ... addresses) {
            this.addresses.addAll(Arrays.asList(addresses));
            return this;
        }

        @Override
        public T build() {
            return (T)new BasicDataCenterInfo(this.name, this.addresses);
        }
    }
}

