/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry.eviction;

import com.netflix.eureka2.config.EurekaRegistryConfig;
import com.netflix.eureka2.metric.EurekaRegistryMetricFactory;
import com.netflix.eureka2.metric.EvictionQueueMetrics;
import com.netflix.eureka2.registry.Source;
import com.netflix.eureka2.registry.eviction.EvictionItem;
import com.netflix.eureka2.registry.eviction.EvictionQueue;
import com.netflix.eureka2.registry.instance.InstanceInfo;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Producer;
import rx.Scheduler;
import rx.Subscriber;
import rx.functions.Action0;
import rx.schedulers.Schedulers;

public class EvictionQueueImpl
implements EvictionQueue {
    private static final Logger logger = LoggerFactory.getLogger(EvictionQueueImpl.class);
    private final long evictionTimeoutMs;
    private final EvictionQueueMetrics evictionQueueMetrics;
    private final Scheduler.Worker worker;
    private final AtomicInteger queueSize;
    private final Deque<EvictionItem> queue = new ConcurrentLinkedDeque<EvictionItem>();
    private final AtomicReference<Subscriber<EvictionItem>> evictionSubscriber = new AtomicReference();
    private final AtomicLong evictionQuota = new AtomicLong();
    private final Action0 pushAction = new Action0(){

        public void call() {
            long now = EvictionQueueImpl.this.worker.now();
            while (EvictionQueueImpl.this.evictionQuota.get() > 0L && !EvictionQueueImpl.this.queue.isEmpty() && ((EvictionItem)EvictionQueueImpl.this.queue.peek()).getExpiryTime() <= now) {
                EvictionItem item = (EvictionItem)EvictionQueueImpl.this.queue.poll();
                EvictionQueueImpl.this.queueSize.decrementAndGet();
                EvictionQueueImpl.this.evictionQuota.decrementAndGet();
                EvictionQueueImpl.this.evictionQueueMetrics.decrementEvictionQueueCounter();
                EvictionQueueImpl.this.evictionQueueMetrics.setEvictionQueueSize(EvictionQueueImpl.this.queueSize.get());
                logger.debug("Attempting to evict registry entry {}/{}", (Object)item.getSource(), (Object)item.getInstanceInfo().getId());
                ((Subscriber)EvictionQueueImpl.this.evictionSubscriber.get()).onNext((Object)item);
            }
            long scheduleDelay = EvictionQueueImpl.this.evictionTimeoutMs;
            if (!EvictionQueueImpl.this.queue.isEmpty() && (scheduleDelay = ((EvictionItem)EvictionQueueImpl.this.queue.peek()).getExpiryTime() - now) <= 0L) {
                scheduleDelay = Math.max(100L, EvictionQueueImpl.this.evictionTimeoutMs / 10L);
            }
            EvictionQueueImpl.this.worker.schedule(EvictionQueueImpl.this.pushAction, scheduleDelay, TimeUnit.MILLISECONDS);
        }
    };

    @Inject
    public EvictionQueueImpl(EurekaRegistryConfig config, EurekaRegistryMetricFactory metricFactory) {
        this(config.getEvictionTimeoutMs(), metricFactory, Schedulers.computation());
    }

    public EvictionQueueImpl(long evictionTimeoutMs, EurekaRegistryMetricFactory metricFactory) {
        this(evictionTimeoutMs, metricFactory, Schedulers.computation());
    }

    public EvictionQueueImpl(long evictionTimeoutMs, EurekaRegistryMetricFactory metricFactory, Scheduler scheduler) {
        this.evictionTimeoutMs = evictionTimeoutMs;
        this.evictionQueueMetrics = metricFactory.getEvictionQueueMetrics();
        this.worker = scheduler.createWorker();
        this.queueSize = new AtomicInteger(0);
    }

    @Override
    public void add(InstanceInfo instanceInfo, Source source) {
        this.queue.addLast(new EvictionItem(instanceInfo, source, this.worker.now() + this.evictionTimeoutMs));
        this.queueSize.incrementAndGet();
        this.evictionQueueMetrics.incrementEvictionQueueAddCounter();
        this.evictionQueueMetrics.setEvictionQueueSize(this.queueSize.get());
    }

    @Override
    public Observable<EvictionItem> pendingEvictions() {
        return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<EvictionItem>(){

            public void call(Subscriber<? super EvictionItem> subscriber) {
                if (!EvictionQueueImpl.this.evictionSubscriber.compareAndSet(null, subscriber)) {
                    throw new IllegalStateException("Only one subscriber allowed in the eviction queue");
                }
                subscriber.setProducer(new Producer(){

                    public void request(long n) {
                        EvictionQueueImpl.this.evictionQuota.getAndAdd(n);
                    }
                });
                EvictionQueueImpl.this.worker.schedule(EvictionQueueImpl.this.pushAction, EvictionQueueImpl.this.evictionTimeoutMs, TimeUnit.MILLISECONDS);
            }
        });
    }

    @Override
    public int size() {
        int size = this.queueSize.get();
        if (size < 0) {
            logger.warn("Eviction queue size is less than 0: {}", (Object)size);
            size = 0;
        }
        return size;
    }

    @Override
    public void shutdown() {
        logger.info("Shutting down the eviction queue");
        this.worker.unsubscribe();
        this.queue.clear();
    }
}

