/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry.eviction;

import com.netflix.eureka2.config.EurekaRegistryConfig;
import com.netflix.eureka2.registry.eviction.EvictionStrategy;
import com.netflix.eureka2.registry.eviction.PercentageDropEvictionStrategy;
import javax.inject.Inject;
import javax.inject.Provider;

public class EvictionStrategyProvider
implements Provider<EvictionStrategy> {
    private final EurekaRegistryConfig config;

    @Inject
    public EvictionStrategyProvider(EurekaRegistryConfig config) {
        this.config = config;
    }

    public EvictionStrategy get() {
        StrategyType type = this.config.getEvictionStrategyType();
        switch (type) {
            case PercentageDrop: {
                return new PercentageDropEvictionStrategy(Integer.parseInt(this.config.getEvictionStrategyValue()));
            }
        }
        throw new IllegalArgumentException("Unrecognized eviction strategy " + (Object)((Object)type));
    }

    public static enum StrategyType {
        PercentageDrop;

    }
}

