/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry.eviction;

import com.netflix.eureka2.registry.eviction.EvictionStrategy;

public class PercentageDropEvictionStrategy
implements EvictionStrategy {
    private final double dropRatio;

    public PercentageDropEvictionStrategy(int allowedPercentageDrop) {
        this.dropRatio = (double)allowedPercentageDrop / 100.0;
    }

    @Override
    public int allowedToEvict(int expectedRegistrySize, int actualRegistrySize) {
        int maxAllowed = (int)(this.dropRatio * (double)expectedRegistrySize);
        int currentDif = expectedRegistrySize - actualRegistrySize;
        return maxAllowed - currentDif;
    }
}

