/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry.instance;

import com.netflix.eureka2.registry.instance.InstanceInfo;
import com.netflix.eureka2.registry.instance.InstanceInfoField;

public class Delta<ValueType> {
    private String id;
    private InstanceInfoField<ValueType> field;
    private ValueType value;

    private Delta() {
    }

    InstanceInfo.Builder applyTo(InstanceInfo.Builder instanceInfoBuilder) {
        return this.field.update(instanceInfoBuilder, this.value);
    }

    public String getId() {
        return this.id;
    }

    public InstanceInfoField<ValueType> getField() {
        return this.field;
    }

    public ValueType getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Delta)) {
            return false;
        }
        Delta delta = (Delta)o;
        if (this.field != null ? !this.field.equals(delta.field) : delta.field != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(delta.id) : delta.id != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(delta.value) : delta.value != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Delta{id='" + this.id + '\'' + ", field=" + this.field + ", value=" + this.value + '}';
    }

    public static final class Builder {
        private String id;
        Delta<?> delta;

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public <T> Builder withDelta(InstanceInfoField<T> field, T value) {
            Delta delta = new Delta();
            delta.field = field;
            delta.value = value;
            this.delta = delta;
            return this;
        }

        public Delta<?> build() {
            ((Delta)this.delta).id = this.id;
            if (((Delta)this.delta).id == null || ((Delta)this.delta).field == null) {
                throw new IllegalStateException("Incomplete delta information");
            }
            return this.delta;
        }
    }
}

