/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry.instance;

import java.util.Set;

public class ServicePort {
    private final String name;
    private final Integer port;
    private final boolean secure;
    private final Set<String> addressLabels;

    protected ServicePort() {
        this.name = null;
        this.port = 0;
        this.secure = false;
        this.addressLabels = null;
    }

    public ServicePort(Integer port, boolean secure) {
        this(null, port, secure, null);
    }

    public ServicePort(String name, Integer port, boolean secure) {
        this(name, port, secure, null);
    }

    public ServicePort(String name, Integer port, boolean secure, Set<String> addressLabels) {
        this.name = name;
        this.port = port;
        this.secure = secure;
        this.addressLabels = addressLabels;
    }

    public String getName() {
        return this.name;
    }

    public Integer getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Set<String> getAddressLabels() {
        return this.addressLabels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServicePort that = (ServicePort)o;
        if (this.secure != that.secure) {
            return false;
        }
        if (this.addressLabels != null ? !this.addressLabels.equals(that.addressLabels) : that.addressLabels != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.port != null ? !this.port.equals(that.port) : that.port != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
        result = 31 * result + (this.secure ? 1 : 0);
        result = 31 * result + (this.addressLabels != null ? this.addressLabels.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ServicePort{name='" + this.name + '\'' + ", port=" + this.port + ", secure=" + this.secure + ", addressLabels=" + this.addressLabels + '}';
    }

    public static class ServicePortBuilder {
        private String name;
        private Integer port;
        private boolean secure;
        private Set<String> addressLabels;

        private ServicePortBuilder() {
        }

        public static ServicePortBuilder aServicePort() {
            return new ServicePortBuilder();
        }

        public ServicePortBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public ServicePortBuilder withPort(Integer port) {
            this.port = port;
            return this;
        }

        public ServicePortBuilder withSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public ServicePortBuilder withAddressLabels(Set<String> addressLabels) {
            this.addressLabels = addressLabels;
            return this;
        }

        public ServicePortBuilder but() {
            return ServicePortBuilder.aServicePort().withName(this.name).withPort(this.port).withSecure(this.secure).withAddressLabels(this.addressLabels);
        }

        public ServicePort build() {
            return new ServicePort(this.name, this.port, this.secure, this.addressLabels);
        }
    }
}

