/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry.selector;

import com.netflix.eureka2.registry.instance.NetworkAddress;
import com.netflix.eureka2.registry.selector.DataSelector;
import com.netflix.eureka2.utils.SystemUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class AddressSelector
extends DataSelector<NetworkAddress, AddressSelector> {
    private AddressSelector() {
    }

    public static AddressSelector selectBy() {
        return new AddressSelector();
    }

    public AddressSelector label(String ... labels) {
        this.current.add(new LabelCriteria(labels));
        return this;
    }

    public AddressSelector protocolType(NetworkAddress.ProtocolType ... protocolTypes) {
        this.current.add(new ProtocolTypeCriteria(protocolTypes));
        return this;
    }

    public AddressSelector publicIp(boolean publicAddress) {
        this.current.add(new PublicIpCriteria(publicAddress));
        return this;
    }

    public NetworkAddress returnAddress(List<NetworkAddress> addresses) {
        Iterator<NetworkAddress> it = this.applyQuery(addresses.iterator());
        return it.hasNext() ? it.next() : null;
    }

    public List<NetworkAddress> returnAddressList(List<NetworkAddress> addresses) {
        Iterator<NetworkAddress> it = this.applyQuery(addresses.iterator());
        ArrayList<NetworkAddress> addressList = new ArrayList<NetworkAddress>();
        while (it.hasNext()) {
            addressList.add(it.next());
        }
        return addressList;
    }

    public String returnNameOrIp(List<NetworkAddress> addresses) {
        Iterator<NetworkAddress> it = this.applyQuery(addresses.iterator());
        if (it.hasNext()) {
            NetworkAddress address = it.next();
            return address.getHostName() != null ? address.getHostName() : address.getIpAddress();
        }
        return null;
    }

    public List<String> returnNameOrIpList(List<NetworkAddress> addresses) {
        Iterator<NetworkAddress> it = this.applyQuery(addresses.iterator());
        ArrayList<String> addressList = new ArrayList<String>();
        while (it.hasNext()) {
            NetworkAddress address = it.next();
            addressList.add(address.getHostName() != null ? address.getHostName() : address.getIpAddress());
        }
        return addressList;
    }

    static class PublicIpCriteria
    extends DataSelector.Criteria<NetworkAddress, Boolean> {
        PublicIpCriteria(boolean publicAddress) {
            super(publicAddress);
        }

        @Override
        protected boolean matches(Boolean value, NetworkAddress endpoint) {
            String ipAddress = endpoint.getIpAddress();
            if (ipAddress == null) {
                return false;
            }
            return SystemUtil.isPublic(ipAddress) == value;
        }
    }

    static class ProtocolTypeCriteria
    extends DataSelector.Criteria<NetworkAddress, NetworkAddress.ProtocolType> {
        ProtocolTypeCriteria(NetworkAddress.ProtocolType ... protocolTypes) {
            super(protocolTypes);
        }

        @Override
        protected boolean matches(NetworkAddress.ProtocolType value, NetworkAddress endpoint) {
            return endpoint.getProtocolType() == value;
        }
    }

    static class LabelCriteria
    extends DataSelector.Criteria<NetworkAddress, String> {
        LabelCriteria(String ... labels) {
            super(labels);
        }

        @Override
        protected boolean matches(String value, NetworkAddress endpoint) {
            return value.equals(endpoint.getLabel());
        }
    }
}

