/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.registry.selector;

import com.netflix.eureka2.registry.instance.InstanceInfo;
import com.netflix.eureka2.registry.instance.NetworkAddress;
import com.netflix.eureka2.registry.selector.DataSelector;
import com.netflix.eureka2.utils.SystemUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ServiceSelector
extends DataSelector<InstanceInfo.ServiceEndpoint, ServiceSelector> {
    private ServiceSelector() {
    }

    public static ServiceSelector selectBy() {
        return new ServiceSelector();
    }

    public ServiceSelector protocolType(NetworkAddress.ProtocolType ... protocolTypes) {
        this.current.add(new ProtocolTypeCriteria(protocolTypes));
        return this;
    }

    public ServiceSelector addressLabel(String ... addressLabels) {
        this.current.add(new AddressLabelCriteria(addressLabels));
        return this;
    }

    public ServiceSelector serviceLabel(String ... serviceLabels) {
        this.current.add(new ServiceLabelCriteria(serviceLabels));
        return this;
    }

    public ServiceSelector secure(boolean securePort) {
        this.current.add(new SecurePortCriteria(securePort));
        return this;
    }

    public ServiceSelector publicIp(boolean publicAddress) {
        this.current.add(new PublicIpCriteria(publicAddress));
        return this;
    }

    public InetSocketAddress returnServiceAddress(InstanceInfo instanceInfo) {
        InstanceInfo.ServiceEndpoint endpoint = this.returnServiceEndpoint(instanceInfo);
        if (endpoint == null) {
            return null;
        }
        String address = endpoint.getAddress().getHostName();
        if (address == null) {
            address = endpoint.getAddress().getIpAddress();
        }
        return new InetSocketAddress(address, (int)endpoint.getServicePort().getPort());
    }

    public NetworkAddress returnNetworkAddress(InstanceInfo instanceInfo) {
        InstanceInfo.ServiceEndpoint endpoint = this.returnServiceEndpoint(instanceInfo);
        return endpoint != null ? endpoint.getAddress() : null;
    }

    public List<NetworkAddress> returnNetworkAddresses(InstanceInfo instanceInfo) {
        ArrayList<NetworkAddress> addresses = new ArrayList<NetworkAddress>();
        Iterator<InstanceInfo.ServiceEndpoint> it = this.returnServiceEndpoints(instanceInfo);
        while (it.hasNext()) {
            addresses.add(it.next().getAddress());
        }
        return addresses;
    }

    public InstanceInfo.ServiceEndpoint returnServiceEndpoint(InstanceInfo instanceInfo) {
        Iterator<InstanceInfo.ServiceEndpoint> it = this.returnServiceEndpoints(instanceInfo);
        return it.hasNext() ? it.next() : null;
    }

    public Iterator<InstanceInfo.ServiceEndpoint> returnServiceEndpoints(InstanceInfo instanceInfo) {
        Iterator<InstanceInfo.ServiceEndpoint> endpointIt = instanceInfo.serviceEndpoints();
        return this.applyQuery(endpointIt);
    }

    static class PublicIpCriteria
    extends DataSelector.Criteria<InstanceInfo.ServiceEndpoint, Boolean> {
        PublicIpCriteria(boolean publicAddress) {
            super(publicAddress);
        }

        @Override
        protected boolean matches(Boolean value, InstanceInfo.ServiceEndpoint endpoint) {
            String ipAddress = endpoint.getAddress().getIpAddress();
            if (ipAddress == null) {
                return false;
            }
            return SystemUtil.isPublic(ipAddress) == value;
        }
    }

    static class SecurePortCriteria
    extends DataSelector.Criteria<InstanceInfo.ServiceEndpoint, Boolean> {
        SecurePortCriteria(boolean securePort) {
            super(securePort);
        }

        @Override
        protected boolean matches(Boolean value, InstanceInfo.ServiceEndpoint endpoint) {
            return endpoint.getServicePort().isSecure() == value.booleanValue();
        }
    }

    static class ServiceLabelCriteria
    extends DataSelector.Criteria<InstanceInfo.ServiceEndpoint, String> {
        ServiceLabelCriteria(String ... labels) {
            super(labels);
        }

        @Override
        protected boolean matches(String value, InstanceInfo.ServiceEndpoint endpoint) {
            return value.equals(endpoint.getServicePort().getName());
        }
    }

    static class AddressLabelCriteria
    extends DataSelector.Criteria<InstanceInfo.ServiceEndpoint, String> {
        AddressLabelCriteria(String ... labels) {
            super(labels);
        }

        @Override
        protected boolean matches(String value, InstanceInfo.ServiceEndpoint endpoint) {
            return value.equals(endpoint.getAddress().getLabel());
        }
    }

    static class ProtocolTypeCriteria
    extends DataSelector.Criteria<InstanceInfo.ServiceEndpoint, NetworkAddress.ProtocolType> {
        ProtocolTypeCriteria(NetworkAddress.ProtocolType ... protocolTypes) {
            super(protocolTypes);
        }

        @Override
        protected boolean matches(NetworkAddress.ProtocolType value, InstanceInfo.ServiceEndpoint endpoint) {
            return endpoint.getAddress().getProtocolType() == value;
        }
    }
}

