/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka2.utils.rx;

import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.schedulers.Schedulers;

public class RetryStrategyFunc
implements Func1<Observable<? extends Throwable>, Observable<Long>> {
    private final long retryIntervalMillis;
    private final int numRetries;
    private final boolean backoffRetry;
    private final Scheduler scheduler;

    public RetryStrategyFunc(long retryIntervalMillis) {
        this(retryIntervalMillis, -1, false);
    }

    public RetryStrategyFunc(long retryIntervalMillis, Scheduler scheduler) {
        this(retryIntervalMillis, -1, false, scheduler);
    }

    public RetryStrategyFunc(long retryIntervalMillis, int totalRetries, boolean exponentialBackoff) {
        this(retryIntervalMillis, totalRetries, exponentialBackoff, Schedulers.computation());
    }

    public RetryStrategyFunc(long retryIntervalMillis, int totalRetries, boolean exponentialBackoff, Scheduler scheduler) {
        this.retryIntervalMillis = retryIntervalMillis;
        this.numRetries = totalRetries;
        this.backoffRetry = exponentialBackoff;
        this.scheduler = scheduler;
    }

    public Observable<Long> call(Observable<? extends Throwable> observable) {
        Observable ticker = this.numRetries > 0 ? Observable.range((int)1, (int)this.numRetries) : Observable.just((Object)1).repeat();
        return observable.zipWith(ticker, (Func2)new Func2<Throwable, Integer, Long>(){

            public Long call(Throwable n, Integer i) {
                if (RetryStrategyFunc.this.backoffRetry) {
                    return (long)Math.pow(2.0, i.intValue()) * RetryStrategyFunc.this.retryIntervalMillis;
                }
                return RetryStrategyFunc.this.retryIntervalMillis;
            }
        }).flatMap((Func1)new Func1<Long, Observable<Long>>(){

            public Observable<Long> call(Long i) {
                return Observable.timer((long)i, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)RetryStrategyFunc.this.scheduler);
            }
        });
    }
}

