/*
 * Decompiled with CFR 0.152.
 */
package feign.httpclient;

import feign.Client;
import feign.Request;
import feign.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public final class ApacheHttpClient
implements Client {
    private static final String ACCEPT_HEADER_NAME = "Accept";
    private final HttpClient client;

    public ApacheHttpClient() {
        this((HttpClient)HttpClientBuilder.create().build());
    }

    public ApacheHttpClient(HttpClient client) {
        this.client = client;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        HttpUriRequest httpUriRequest;
        try {
            httpUriRequest = this.toHttpUriRequest(request, options);
        }
        catch (URISyntaxException e) {
            throw new IOException("URL '" + request.url() + "' couldn't be parsed into a URI", e);
        }
        HttpResponse httpResponse = this.client.execute(httpUriRequest);
        return this.toFeignResponse(httpResponse);
    }

    HttpUriRequest toHttpUriRequest(Request request, Request.Options options) throws UnsupportedEncodingException, MalformedURLException, URISyntaxException {
        RequestBuilder requestBuilder = RequestBuilder.create((String)request.method());
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(options.connectTimeoutMillis()).setSocketTimeout(options.readTimeoutMillis()).build();
        requestBuilder.setConfig(requestConfig);
        URI uri = new URIBuilder(request.url()).build();
        requestBuilder.setUri(uri.getScheme() + "://" + uri.getAuthority() + uri.getPath());
        List queryParams = URLEncodedUtils.parse((URI)uri, (String)requestBuilder.getCharset().name());
        for (NameValuePair queryParam : queryParams) {
            requestBuilder.addParameter(queryParam);
        }
        if (request.body() != null) {
            StringEntity entity = request.charset() != null ? new StringEntity(new String(request.body(), request.charset())) : new ByteArrayEntity(request.body());
            requestBuilder.setEntity((HttpEntity)entity);
        }
        boolean hasAcceptHeader = false;
        for (Map.Entry headerEntry : request.headers().entrySet()) {
            String headerName = (String)headerEntry.getKey();
            if (headerName.equalsIgnoreCase(ACCEPT_HEADER_NAME)) {
                hasAcceptHeader = true;
            }
            if (headerName.equalsIgnoreCase("Content-Length") && requestBuilder.getHeaders(headerName) != null) continue;
            for (String headerValue : (Collection)headerEntry.getValue()) {
                requestBuilder.addHeader(headerName, headerValue);
            }
        }
        if (!hasAcceptHeader) {
            requestBuilder.addHeader(ACCEPT_HEADER_NAME, "*/*");
        }
        return requestBuilder.build();
    }

    Response toFeignResponse(HttpResponse httpResponse) throws IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        String reason = statusLine.getReasonPhrase();
        HashMap<String, ArrayList<String>> headers = new HashMap<String, ArrayList<String>>();
        for (Header header : httpResponse.getAllHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            ArrayList<String> headerValues = (ArrayList<String>)headers.get(name);
            if (headerValues == null) {
                headerValues = new ArrayList<String>();
                headers.put(name, headerValues);
            }
            headerValues.add(value);
        }
        return Response.create((int)statusCode, (String)reason, headers, (Response.Body)this.toFeignBody(httpResponse));
    }

    Response.Body toFeignBody(HttpResponse httpResponse) throws IOException {
        HttpEntity entity = httpResponse.getEntity();
        final Integer length = entity != null && entity.getContentLength() != -1L ? Integer.valueOf((int)entity.getContentLength()) : null;
        final ByteArrayInputStream input = entity != null ? new ByteArrayInputStream(EntityUtils.toByteArray((HttpEntity)entity)) : null;
        return new Response.Body(){

            public void close() throws IOException {
                if (input != null) {
                    input.close();
                }
            }

            public Integer length() {
                return length;
            }

            public boolean isRepeatable() {
                return false;
            }

            public InputStream asInputStream() throws IOException {
                return input;
            }

            public Reader asReader() throws IOException {
                return new InputStreamReader(input);
            }
        };
    }
}

