/*
 * Decompiled with CFR 0.152.
 */
package feign.hystrix;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import feign.InvocationHandlerFactory;
import feign.Target;
import feign.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;

final class HystrixInvocationHandler
implements InvocationHandler {
    private final Target target;
    private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;

    HystrixInvocationHandler(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        this.target = (Target)Util.checkNotNull((Object)target, (String)"target", (Object[])new Object[0]);
        this.dispatch = (Map)Util.checkNotNull(dispatch, (String)"dispatch", (Object[])new Object[0]);
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        String groupKey = this.target.name();
        String commandKey = method.getName();
        HystrixCommand.Setter setter = HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)groupKey)).andCommandKey(HystrixCommandKey.Factory.asKey((String)commandKey));
        HystrixCommand<Object> hystrixCommand = new HystrixCommand<Object>(setter){

            protected Object run() throws Exception {
                try {
                    return ((InvocationHandlerFactory.MethodHandler)HystrixInvocationHandler.this.dispatch.get(method)).invoke(args);
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw (Error)t;
                }
            }
        };
        if (HystrixCommand.class.isAssignableFrom(method.getReturnType())) {
            return hystrixCommand;
        }
        return hystrixCommand.execute();
    }

    static final class Factory
    implements InvocationHandlerFactory {
        Factory() {
        }

        public InvocationHandler create(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
            return new HystrixInvocationHandler(target, dispatch);
        }
    }
}

