/*
 * Decompiled with CFR 0.152.
 */
package feign.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import feign.Response;
import feign.codec.Decoder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collections;

public class JacksonDecoder
implements Decoder {
    private final ObjectMapper mapper;

    public JacksonDecoder() {
        this(Collections.emptyList());
    }

    public JacksonDecoder(Iterable<Module> modules) {
        this(new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModules(modules));
    }

    public JacksonDecoder(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public Object decode(Response response, Type type) throws IOException {
        if (response.body() == null) {
            return null;
        }
        InputStream inputStream = response.body().asInputStream();
        try {
            return this.mapper.readValue(inputStream, this.mapper.constructType(type));
        }
        catch (RuntimeJsonMappingException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)IOException.class.cast(e.getCause());
            }
            throw e;
        }
    }
}

