/*
 * Decompiled with CFR 0.152.
 */
package feign.okhttp;

import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.ResponseBody;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class OkHttpClient
implements Client {
    private final com.squareup.okhttp.OkHttpClient delegate;

    public OkHttpClient() {
        this(new com.squareup.okhttp.OkHttpClient());
    }

    public OkHttpClient(com.squareup.okhttp.OkHttpClient delegate) {
        this.delegate = delegate;
    }

    static com.squareup.okhttp.Request toOkHttpRequest(Request input) {
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(input.url());
        MediaType mediaType = null;
        boolean hasAcceptHeader = false;
        for (String field : input.headers().keySet()) {
            if (field.equalsIgnoreCase("Accept")) {
                hasAcceptHeader = true;
            }
            for (String value : (Collection)input.headers().get(field)) {
                if (field.equalsIgnoreCase("Content-Type")) {
                    mediaType = MediaType.parse((String)value);
                    if (input.charset() == null) continue;
                    mediaType.charset(input.charset());
                    continue;
                }
                requestBuilder.addHeader(field, value);
            }
        }
        if (!hasAcceptHeader) {
            requestBuilder.addHeader("Accept", "*/*");
        }
        RequestBody body = input.body() != null ? RequestBody.create(mediaType, (byte[])input.body()) : null;
        requestBuilder.method(input.method(), body);
        return requestBuilder.build();
    }

    private static Response toFeignResponse(com.squareup.okhttp.Response input) throws IOException {
        return Response.create((int)input.code(), (String)input.message(), OkHttpClient.toMap(input.headers()), (Response.Body)OkHttpClient.toBody(input.body()));
    }

    private static Map<String, Collection<String>> toMap(Headers headers) {
        return headers.toMultimap();
    }

    private static Response.Body toBody(final ResponseBody input) throws IOException {
        if (input == null || input.contentLength() == 0L) {
            return null;
        }
        if (input.contentLength() > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Length too long " + input.contentLength());
        }
        final Integer length = input.contentLength() != -1L ? Integer.valueOf((int)input.contentLength()) : null;
        return new Response.Body(){

            public void close() throws IOException {
                input.close();
            }

            public Integer length() {
                return length;
            }

            public boolean isRepeatable() {
                return false;
            }

            public InputStream asInputStream() throws IOException {
                return input.byteStream();
            }

            public Reader asReader() throws IOException {
                return input.charStream();
            }
        };
    }

    public Response execute(Request input, Request.Options options) throws IOException {
        com.squareup.okhttp.OkHttpClient requestScoped;
        if (this.delegate.getConnectTimeout() != options.connectTimeoutMillis() || this.delegate.getReadTimeout() != options.readTimeoutMillis()) {
            requestScoped = this.delegate.clone();
            requestScoped.setConnectTimeout((long)options.connectTimeoutMillis(), TimeUnit.MILLISECONDS);
            requestScoped.setReadTimeout((long)options.readTimeoutMillis(), TimeUnit.MILLISECONDS);
        } else {
            requestScoped = this.delegate;
        }
        com.squareup.okhttp.Request request = OkHttpClient.toOkHttpRequest(input);
        com.squareup.okhttp.Response response = requestScoped.newCall(request).execute();
        return OkHttpClient.toFeignResponse(response);
    }
}

