/*
 * Decompiled with CFR 0.152.
 */
package feign.ribbon;

import com.netflix.client.ClientFactory;
import com.netflix.loadbalancer.AbstractLoadBalancer;
import com.netflix.loadbalancer.Server;
import feign.Request;
import feign.RequestTemplate;
import feign.Target;
import feign.Util;
import java.net.URI;

public class LoadBalancingTarget<T>
implements Target<T> {
    private final String name;
    private final String scheme;
    private final Class<T> type;
    private final AbstractLoadBalancer lb;

    public static <T> LoadBalancingTarget<T> create(Class<T> type, String schemeName) {
        URI asUri = URI.create(schemeName);
        return new LoadBalancingTarget<T>(type, asUri.getScheme(), asUri.getHost());
    }

    protected LoadBalancingTarget(Class<T> type, String scheme, String name) {
        this.type = (Class)Util.checkNotNull(type, (String)"type", (Object[])new Object[0]);
        this.scheme = (String)Util.checkNotNull((Object)scheme, (String)"scheme", (Object[])new Object[0]);
        this.name = (String)Util.checkNotNull((Object)name, (String)"name", (Object[])new Object[0]);
        this.lb = (AbstractLoadBalancer)AbstractLoadBalancer.class.cast(ClientFactory.getNamedLoadBalancer((String)this.name()));
    }

    public Class<T> type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String url() {
        return this.name;
    }

    public AbstractLoadBalancer lb() {
        return this.lb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request apply(RequestTemplate input) {
        Server currentServer = this.lb.chooseServer(null);
        String url = String.format("%s://%s", this.scheme, currentServer.getHostPort());
        input.insert(0, (CharSequence)url);
        try {
            Request request = input.request();
            return request;
        }
        finally {
            this.lb.getLoadBalancerStats().incrementNumRequests(currentServer);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof LoadBalancingTarget) {
            LoadBalancingTarget other = (LoadBalancingTarget)obj;
            return this.type.equals(other.type) && this.name.equals(other.name);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "LoadBalancingTarget(type=" + this.type.getSimpleName() + ", name=" + this.name + ")";
    }
}

