/*
 * Decompiled with CFR 0.152.
 */
package feign.ribbon;

import com.netflix.client.ClientException;
import com.netflix.client.ClientFactory;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import feign.Client;
import feign.Request;
import feign.Response;
import feign.ribbon.LBClient;
import java.io.IOException;
import java.net.URI;

public class RibbonClient
implements Client {
    private final Client delegate;

    public RibbonClient() {
        this.delegate = new Client.Default(null, null);
    }

    public RibbonClient(Client delegate) {
        this.delegate = delegate;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        try {
            URI asUri = URI.create(request.url());
            String clientName = asUri.getHost();
            URI uriWithoutSchemeAndPort = URI.create(request.url().replace(asUri.getScheme() + "://" + asUri.getHost(), ""));
            LBClient.RibbonRequest ribbonRequest = new LBClient.RibbonRequest(request, uriWithoutSchemeAndPort);
            return ((LBClient.RibbonResponse)this.lbClient(clientName).executeWithLoadBalancer(ribbonRequest)).toResponse();
        }
        catch (ClientException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)IOException.class.cast(e.getCause());
            }
            throw new RuntimeException(e);
        }
    }

    private LBClient lbClient(String clientName) {
        IClientConfig config = ClientFactory.getNamedConfig((String)clientName);
        ILoadBalancer lb = ClientFactory.getNamedLoadBalancer((String)clientName);
        return new LBClient(this.delegate, lb, config);
    }
}

