/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs.aws;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.web.client.RestTemplate;

@Profile(value={"aws"})
@Configuration
public class AwsMvcConfig {
    private static final Logger log = LoggerFactory.getLogger(AwsMvcConfig.class);
    protected String publicHostNameGet = "http://169.254.169.254/latest/meta-data/public-hostname";
    protected String localIPV4HostNameGet = "http://169.254.169.254/latest/meta-data/local-ipv4";

    @Bean
    public String hostName(@Qualifier(value="genieRestTemplate") RestTemplate restTemplate) throws IOException {
        String result;
        try {
            result = (String)restTemplate.getForObject(this.publicHostNameGet, String.class, new Object[0]);
            log.debug("AWS Public Hostname: {}", (Object)result);
        }
        catch (Exception e) {
            result = (String)restTemplate.getForObject(this.localIPV4HostNameGet, String.class, new Object[0]);
            log.debug("AWS IPV4 Hostname: {}", (Object)result);
        }
        return result;
    }
}

