/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.hateoas.assemblers;

import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.controllers.JobRestController;
import com.netflix.genie.web.hateoas.resources.JobRequestResource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;

@Component
public class JobRequestResourceAssembler
implements ResourceAssembler<JobRequest, JobRequestResource> {
    public JobRequestResource toResource(JobRequest jobRequest) {
        String id = (String)jobRequest.getId().orElseThrow(IllegalArgumentException::new);
        JobRequestResource jobRequestResource = new JobRequestResource(jobRequest);
        try {
            jobRequestResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobRequest(id))).withSelfRel());
            jobRequestResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJob(id))).withRel("job"));
            jobRequestResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobExecution(id))).withRel("execution"));
            String output = "output";
            jobRequestResource.add(((ControllerLinkBuilder)((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(JobRestController.class).slash((Object)id)).slash((Object)"output")).withRel("output"));
            jobRequestResource.add(ControllerLinkBuilder.linkTo((Object)((JobRestController)ControllerLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobStatus(id)).withRel("status"));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return jobRequestResource;
    }
}

