/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.resources.handlers;

import com.netflix.genie.web.resources.writers.DirectoryWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.resource.EncodedResource;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.springframework.web.servlet.resource.VersionedResource;

public class GenieResourceHttpRequestHandler
extends ResourceHttpRequestHandler {
    public static final String GENIE_JOB_IS_ROOT_DIRECTORY = GenieResourceHttpRequestHandler.class.getName() + ".isRootDirectory";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String BYTES = "bytes";
    private DirectoryWriter directoryWriter;

    public GenieResourceHttpRequestHandler(DirectoryWriter directoryWriter) {
        this.directoryWriter = directoryWriter;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Assert.state((this.getLocations().size() == 1 ? 1 : 0) != 0, (String)"Too many resource locations");
        Assert.state((request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE) != null ? 1 : 0) != 0, (String)("Request doesn't have a " + HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE + " attribute."));
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        Resource resource = ((Resource)this.getLocations().get(0)).createRelative(path);
        if (!resource.exists()) {
            response.sendError(HttpStatus.NOT_FOUND.value());
            return;
        }
        File file = resource.getFile();
        if (file.isDirectory()) {
            Object rootDirAttribute = request.getAttribute(GENIE_JOB_IS_ROOT_DIRECTORY);
            boolean isRootDirectory = rootDirAttribute != null ? (Boolean)rootDirAttribute : true;
            String accept = request.getHeader("Accept");
            String requestUrl = request.getHeader("Genie-Forwarded-From") != null ? request.getHeader("Genie-Forwarded-From") : request.getRequestURL().toString();
            try {
                if (accept != null && accept.contains("text/html")) {
                    response.setContentType("text/html");
                    response.getOutputStream().write(this.directoryWriter.toHtml(file, requestUrl, !isRootDirectory).getBytes(UTF_8));
                }
                response.setContentType("application/json");
                response.getOutputStream().write(this.directoryWriter.toJson(file, requestUrl, !isRootDirectory).getBytes(UTF_8));
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            super.handleRequest(request, response);
        }
    }

    protected void setHeaders(HttpServletResponse response, Resource resource, MediaType mediaType) throws IOException {
        response.setContentLengthLong(resource.contentLength());
        if (mediaType != null) {
            response.setContentType(mediaType.toString());
        }
        if (resource instanceof EncodedResource) {
            response.setHeader("Content-Encoding", ((EncodedResource)resource).getContentEncoding());
        }
        if (resource instanceof VersionedResource) {
            response.setHeader("ETag", "\"" + ((VersionedResource)resource).getVersion() + "\"");
        }
        response.setHeader("Accept-Ranges", BYTES);
    }

    protected MediaType getMediaType(HttpServletRequest request, Resource resource) {
        MediaType mediaType = super.getMediaType(request, resource);
        return mediaType == null ? MediaType.TEXT_PLAIN : mediaType;
    }
}

