/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.security.oauth2;

import com.netflix.genie.web.security.SecurityUtils;
import com.netflix.genie.web.security.x509.X509UserDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;

@ConditionalOnProperty(value={"genie.security.oauth2.enabled"})
@Configuration
@EnableResourceServer
public class OAuth2Config
extends ResourceServerConfigurerAdapter {
    @Autowired
    private X509UserDetailsService x509UserDetailsService;
    @Value(value="${management.context-path}")
    private String actuatorEndpoint;

    public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
        resources.stateless(false);
    }

    public void configure(HttpSecurity http) throws Exception {
        SecurityUtils.buildAPIHttpSecurity(http, this.x509UserDetailsService, this.actuatorEndpoint);
    }
}

