/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.security.oauth2.pingfederate;

import com.google.common.collect.Sets;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;

public class PingFederateJWTTokenServices
implements ResourceServerTokenServices {
    private static final Logger log = LoggerFactory.getLogger(PingFederateJWTTokenServices.class);
    private static final String ROLE = "ROLE_";
    private static final String GENIE_SCOPE_PREFIX = "genie_";
    private static final int GENIE_SCOPE_PREFIX_LENGTH = "genie_".length();
    private static final SimpleGrantedAuthority USER = new SimpleGrantedAuthority("ROLE_USER");
    private static final SimpleGrantedAuthority ADMIN = new SimpleGrantedAuthority("ROLE_ADMIN");
    private final JwtConsumer jwtConsumer;
    private final Timer loadAuthenticationTimer;

    public PingFederateJWTTokenServices(@NotNull JwtConsumer jwtConsumer, @NotNull Registry registry) {
        this.jwtConsumer = jwtConsumer;
        this.loadAuthenticationTimer = registry.timer("genie.security.oauth2.pingFederate.authentication.timer");
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        long start = System.nanoTime();
        try {
            JwtClaims claims = this.jwtConsumer.processToClaims(accessToken);
            log.debug("Ping Federate JWT Claims: {}", (Object)claims);
            OAuth2Authentication oAuth2Authentication = new OAuth2Authentication(this.getOAuth2Request(claims), null);
            return oAuth2Authentication;
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            throw new InvalidTokenException(e.getMessage(), e);
        }
        finally {
            this.loadAuthenticationTimer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        throw new UnsupportedOperationException("readAccessToken not implemented");
    }

    private OAuth2Request getOAuth2Request(@NotNull JwtClaims claims) throws MalformedClaimException, InvalidTokenException {
        String clientId = (String)claims.getClaimValue("client_id", String.class);
        HashSet scopes = Sets.newHashSet((Iterable)((Iterable)claims.getClaimValue("scope", Collection.class)));
        Set authorities = scopes.stream().map(scope -> {
            if (scope.startsWith(GENIE_SCOPE_PREFIX)) {
                scope = scope.substring(GENIE_SCOPE_PREFIX_LENGTH);
            }
            return new SimpleGrantedAuthority(ROLE + scope.toUpperCase());
        }).collect(Collectors.toSet());
        if (authorities.isEmpty()) {
            throw new InvalidTokenException("No scopes found. Unable to authorize");
        }
        if (authorities.contains(ADMIN)) {
            authorities.add(USER);
        }
        return new OAuth2Request(null, clientId, authorities, true, (Set)scopes, null, null, null, null);
    }
}

