/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.google.common.collect.Lists;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.core.services.FileTransfer;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.hibernate.validator.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;

public class HttpFileTransferImpl
implements FileTransfer {
    private static final Logger log = LoggerFactory.getLogger(HttpFileTransferImpl.class);
    private final UrlValidator validator = new UrlValidator(new String[]{"http", "https"}, 8L);
    private final RestTemplate restTemplate;
    private final Timer downloadTimer;
    private final Timer uploadTimer;
    private final Timer getLastModifiedTimer;

    public HttpFileTransferImpl(@NotNull RestTemplate restTemplate, @NotNull Registry registry) {
        this.restTemplate = restTemplate;
        this.downloadTimer = registry.timer("genie.files.http.download.timer");
        this.uploadTimer = registry.timer("genie.files.http.upload.timer");
        this.getLastModifiedTimer = registry.timer("genie.files.http.getLastModified.timer");
    }

    public boolean isValid(String fileName) throws GenieException {
        log.debug("Called with file name {}", (Object)fileName);
        return this.validator.isValid(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFile(@NotBlank(message="Source file path cannot be empty.") String srcRemotePath, @NotBlank(message="Destination local path cannot be empty") String dstLocalPath) throws GenieException {
        long start = System.nanoTime();
        log.debug("Called with src path {} and destination path {}", (Object)srcRemotePath, (Object)dstLocalPath);
        try {
            final File outputFile = new File(dstLocalPath);
            if (!this.isValid(srcRemotePath)) {
                throw new GenieServerException("Unable to download " + srcRemotePath + " not a valid URL");
            }
            this.restTemplate.execute(srcRemotePath, HttpMethod.GET, requestEntity -> requestEntity.getHeaders().setAccept((List)Lists.newArrayList((Object[])new MediaType[]{MediaType.ALL})), (ResponseExtractor)new ResponseExtractor<Void>(){

                public Void extractData(ClientHttpResponse response) throws IOException {
                    FileUtils.copyInputStreamToFile((InputStream)response.getBody(), (File)outputFile);
                    return null;
                }
            }, new Object[0]);
        }
        finally {
            this.downloadTimer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    public void putFile(@NotBlank(message="Source local path cannot be empty.") String srcLocalPath, @NotBlank(message="Destination remote path cannot be empty") String dstRemotePath) throws GenieException {
        long start = System.nanoTime();
        try {
            throw new UnsupportedOperationException("Saving a file to an HttpEndpoint isn't implemented in this version");
        }
        catch (Throwable throwable) {
            this.uploadTimer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            throw throwable;
        }
    }

    public long getLastModifiedTime(String path) throws GenieException {
        long start = System.nanoTime();
        try {
            URL url = new URL(path);
            long time = this.restTemplate.headForHeaders(url.toURI()).getLastModified();
            long l = time != -1L ? time : Instant.now().toEpochMilli();
            return l;
        }
        catch (MalformedURLException | URISyntaxException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new GenieServerException((Throwable)e);
        }
        finally {
            this.getLastModifiedTimer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }
}

