/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.ClasspathPropertiesFileCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.core.properties.S3FileTransferProperties;
import com.netflix.genie.core.services.impl.S3FileTransferImpl;
import com.netflix.spectator.api.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;

@Profile(value={"s3"})
@Configuration
public class AwsS3Config {
    private static final Logger log = LoggerFactory.getLogger(AwsS3Config.class);

    @Bean
    @ConditionalOnProperty(value={"genie.aws.credentials.file"})
    public ClasspathPropertiesFileCredentialsProvider awsCredentialsFromFile(@Value(value="${genie.aws.credentials.file}") String credentialsFilePath) {
        log.info("Creating file credentials provider bean");
        return new ClasspathPropertiesFileCredentialsProvider(credentialsFilePath);
    }

    @Bean
    @ConditionalOnProperty(value={"genie.aws.credentials.role"})
    public STSAssumeRoleSessionCredentialsProvider awsCredentialsProvider(@Value(value="${genie.aws.credentials.role}") String roleArn) {
        log.info("Creating STS Assume Role Session Credentials provider bean");
        return new STSAssumeRoleSessionCredentialsProvider.Builder(roleArn, "Genie").build();
    }

    @Bean
    @ConditionalOnBean(value={AWSCredentialsProvider.class})
    public AmazonS3 genieS3Client(@Value(value="${genie.retry.s3.noOfRetries:5}") int noOfS3Retries, AWSCredentialsProvider awsCredentialsProvider) {
        ClientConfiguration clientConfiguration = new ClientConfiguration().withRetryPolicy(PredefinedRetryPolicies.getDefaultRetryPolicyWithCustomMaxRetries((int)noOfS3Retries));
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(awsCredentialsProvider)).withClientConfiguration(clientConfiguration)).build();
    }

    @Bean(name={"file.system.s3", "file.system.s3n", "file.system.s3a"})
    @Order(value=1)
    @ConditionalOnBean(value={AmazonS3.class})
    public S3FileTransferImpl s3FileTransferImpl(AmazonS3 s3Client, Registry registry, S3FileTransferProperties s3FileTransferProperties) throws GenieException {
        return new S3FileTransferImpl(s3Client, registry, s3FileTransferProperties);
    }
}

