/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.security.oauth2.pingfederate;

import com.netflix.genie.web.security.oauth2.pingfederate.PingFederateJWTTokenServices;
import com.netflix.genie.web.security.oauth2.pingfederate.PingFederateSecurityConditions;
import com.netflix.genie.web.security.oauth2.pingfederate.PingFederateValidator;
import com.netflix.spectator.api.Registry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import org.apache.commons.lang3.StringUtils;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.Validator;
import org.jose4j.keys.RsaKeyUtil;
import org.jose4j.lang.JoseException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@Conditional(value={PingFederateSecurityConditions.PingFederateJWTEnabled.class})
public class PingFederateJWTConfig {
    @Bean
    public PingFederateValidator pingFederateValidator(Registry registry) {
        return new PingFederateValidator(registry);
    }

    @Bean
    public PublicKey jwtPublicKey(@Value(value="${genie.security.oauth2.pingfederate.jwt.keyValue}") String keyValue) throws IOException, JoseException, InvalidKeySpecException, CertificateException {
        String certBegin = "-----BEGIN CERTIFICATE-----";
        String rsaBegin = "-----BEGIN PUBLIC KEY-----";
        if (StringUtils.isEmpty((CharSequence)keyValue)) {
            throw new IllegalArgumentException("No value set for security.oauth2.resource.jwt.keyValue");
        }
        if (keyValue.startsWith("-----BEGIN CERTIFICATE-----")) {
            try (ByteArrayInputStream bis = new ByteArrayInputStream(keyValue.getBytes("UTF-8"));){
                CertificateFactory fact = CertificateFactory.getInstance("X.509");
                X509Certificate cer = (X509Certificate)fact.generateCertificate(bis);
                PublicKey publicKey = cer.getPublicKey();
                return publicKey;
            }
        }
        if (keyValue.startsWith("-----BEGIN PUBLIC KEY-----")) {
            return new RsaKeyUtil().fromPemEncoded(keyValue);
        }
        throw new IllegalArgumentException("Only support X.509 pem certs or Public RSA Keys for security.oauth2.resource.jwt.keyValue");
    }

    @Bean
    public JwtConsumer jwtConsumer(@Qualifier(value="jwtPublicKey") PublicKey jwtPublicKey, PingFederateValidator pingFederateValidator) {
        return new JwtConsumerBuilder().setVerificationKey((Key)jwtPublicKey).setRequireExpirationTime().registerValidator((Validator)pingFederateValidator).build();
    }

    @Bean
    @Primary
    public PingFederateJWTTokenServices pingFederateJWTTokenServices(JwtConsumer jwtConsumer, Registry registry) {
        return new PingFederateJWTTokenServices(jwtConsumer, registry);
    }
}

