/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.security.oauth2.pingfederate;

import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.ConfigurationCondition;

public class PingFederateSecurityConditions {

    public static class PingFederateJWTEnabled
    extends AllNestedConditions {
        public PingFederateJWTEnabled() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(value={"genie.security.oauth2.pingfederate.jwt.enabled"})
        static class OnPingFederateJwtDisabled {
            OnPingFederateJwtDisabled() {
            }
        }

        @ConditionalOnProperty(value={"genie.security.oauth2.pingfederate.enabled"})
        static class OnPingFederate {
            OnPingFederate() {
            }
        }

        @ConditionalOnProperty(value={"genie.security.oauth2.enabled"})
        static class OnOAuth2 {
            OnOAuth2() {
            }
        }
    }

    public static class PingFederateRemoteEnabled
    extends AllNestedConditions {
        public PingFederateRemoteEnabled() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(value={"genie.security.oauth2.pingfederate.jwt.enabled"}, havingValue="false", matchIfMissing=true)
        static class OnPingFederateJwtDisabled {
            OnPingFederateJwtDisabled() {
            }
        }

        @ConditionalOnProperty(value={"genie.security.oauth2.pingfederate.enabled"})
        static class OnPingFederate {
            OnPingFederate() {
            }
        }

        @ConditionalOnProperty(value={"genie.security.oauth2.enabled"})
        static class OnOAuth2 {
            OnOAuth2() {
            }
        }
    }
}

