/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.tasks;

import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;

@Component
public class TasksCleanup {
    private static final Logger log = LoggerFactory.getLogger(TasksCleanup.class);
    private final ThreadPoolTaskScheduler scheduler;

    @Autowired
    public TasksCleanup(@NotNull ThreadPoolTaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    @EventListener
    public void onShutdown(ContextClosedEvent event) {
        log.info("Shutting down the scheduler due to {}", (Object)event);
        this.scheduler.shutdown();
    }
}

