/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.core.events.GenieEventBus;
import com.netflix.genie.core.jobs.workflow.WorkflowTask;
import com.netflix.genie.core.jpa.repositories.JpaApplicationRepository;
import com.netflix.genie.core.jpa.repositories.JpaClusterRepository;
import com.netflix.genie.core.jpa.repositories.JpaCommandRepository;
import com.netflix.genie.core.jpa.repositories.JpaFileRepository;
import com.netflix.genie.core.jpa.repositories.JpaJobRepository;
import com.netflix.genie.core.jpa.repositories.JpaTagRepository;
import com.netflix.genie.core.jpa.services.JpaApplicationServiceImpl;
import com.netflix.genie.core.jpa.services.JpaClusterServiceImpl;
import com.netflix.genie.core.jpa.services.JpaCommandServiceImpl;
import com.netflix.genie.core.jpa.services.JpaFileServiceImpl;
import com.netflix.genie.core.jpa.services.JpaJobPersistenceServiceImpl;
import com.netflix.genie.core.jpa.services.JpaJobSearchServiceImpl;
import com.netflix.genie.core.jpa.services.JpaTagServiceImpl;
import com.netflix.genie.core.properties.JobsProperties;
import com.netflix.genie.core.services.ApplicationService;
import com.netflix.genie.core.services.AttachmentService;
import com.netflix.genie.core.services.ClusterLoadBalancer;
import com.netflix.genie.core.services.ClusterService;
import com.netflix.genie.core.services.CommandService;
import com.netflix.genie.core.services.FileService;
import com.netflix.genie.core.services.FileTransferFactory;
import com.netflix.genie.core.services.JobCoordinatorService;
import com.netflix.genie.core.services.JobKillService;
import com.netflix.genie.core.services.JobPersistenceService;
import com.netflix.genie.core.services.JobSearchService;
import com.netflix.genie.core.services.JobStateService;
import com.netflix.genie.core.services.JobSubmitterService;
import com.netflix.genie.core.services.MailService;
import com.netflix.genie.core.services.TagService;
import com.netflix.genie.core.services.impl.CacheGenieFileTransferService;
import com.netflix.genie.core.services.impl.DefaultMailServiceImpl;
import com.netflix.genie.core.services.impl.FileSystemAttachmentService;
import com.netflix.genie.core.services.impl.GenieFileTransferService;
import com.netflix.genie.core.services.impl.JobCoordinatorServiceImpl;
import com.netflix.genie.core.services.impl.LocalFileTransferImpl;
import com.netflix.genie.core.services.impl.LocalJobKillServiceImpl;
import com.netflix.genie.core.services.impl.LocalJobRunner;
import com.netflix.genie.core.services.impl.MailServiceImpl;
import com.netflix.genie.core.services.impl.RandomizedClusterLoadBalancerImpl;
import com.netflix.spectator.api.Registry;
import java.util.List;
import org.apache.commons.exec.Executor;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ServiceLocatorFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.mail.javamail.JavaMailSender;

@Configuration
public class ServicesConfig {
    @Bean
    @ConditionalOnProperty(value={"spring.mail.host"})
    public MailService getJavaMailSenderMailService(JavaMailSender javaMailSender, @Value(value="${genie.mail.fromAddress}") String fromAddress) {
        return new MailServiceImpl(javaMailSender, fromAddress);
    }

    @Bean
    @ConditionalOnMissingBean
    public MailService getDefaultMailServiceImpl() {
        return new DefaultMailServiceImpl();
    }

    @Bean
    public ApplicationService applicationService(TagService tagService, JpaTagRepository tagRepository, FileService fileService, JpaFileRepository fileRepository, JpaApplicationRepository applicationRepository, JpaCommandRepository commandRepository) {
        return new JpaApplicationServiceImpl(tagService, tagRepository, fileService, fileRepository, applicationRepository, commandRepository);
    }

    @Bean
    public ClusterService clusterService(TagService tagService, JpaTagRepository tagRepository, FileService fileService, JpaFileRepository fileRepository, JpaClusterRepository clusterRepository, JpaCommandRepository commandRepository) {
        return new JpaClusterServiceImpl(tagService, tagRepository, fileService, fileRepository, clusterRepository, commandRepository);
    }

    @Bean
    public CommandService commandService(TagService tagService, JpaTagRepository tagRepository, FileService fileService, JpaFileRepository fileRepository, JpaCommandRepository commandRepository, JpaApplicationRepository applicationRepository, JpaClusterRepository clusterRepository) {
        return new JpaCommandServiceImpl(tagService, tagRepository, fileService, fileRepository, commandRepository, applicationRepository, clusterRepository);
    }

    @Bean
    public JobSearchService jobSearchService(JpaJobRepository jobRepository, JpaClusterRepository clusterRepository, JpaCommandRepository commandRepository) {
        return new JpaJobSearchServiceImpl(jobRepository, clusterRepository, commandRepository);
    }

    @Bean
    public JobPersistenceService jobPersistenceService(TagService tagService, JpaTagRepository tagRepository, FileService fileService, JpaFileRepository fileRepository, JpaJobRepository jobRepository, JpaApplicationRepository applicationRepository, JpaClusterRepository clusterRepository, JpaCommandRepository commandRepository) {
        return new JpaJobPersistenceServiceImpl(tagService, tagRepository, fileService, fileRepository, jobRepository, applicationRepository, clusterRepository, commandRepository);
    }

    @Bean
    public JobKillService jobKillService(String hostName, JobSearchService jobSearchService, Executor executor, JobsProperties jobsProperties, GenieEventBus genieEventBus, @Qualifier(value="jobsDir") Resource genieWorkingDir, ObjectMapper objectMapper) {
        return new LocalJobKillServiceImpl(hostName, jobSearchService, executor, jobsProperties.getUsers().isRunAsUserEnabled(), genieEventBus, genieWorkingDir, objectMapper);
    }

    @Bean
    public ClusterLoadBalancer clusterLoadBalancer() {
        return new RandomizedClusterLoadBalancerImpl();
    }

    @Bean
    public GenieFileTransferService genieFileTransferService(FileTransferFactory fileTransferFactory) throws GenieException {
        return new GenieFileTransferService(fileTransferFactory);
    }

    @Bean
    public GenieFileTransferService cacheGenieFileTransferService(FileTransferFactory fileTransferFactory, @Value(value="${genie.file.cache.location}") String baseCacheLocation, LocalFileTransferImpl localFileTransfer, Registry registry) throws GenieException {
        return new CacheGenieFileTransferService(fileTransferFactory, baseCacheLocation, localFileTransfer, registry);
    }

    @Bean
    public JobSubmitterService jobSubmitterService(JobPersistenceService jobPersistenceService, GenieEventBus genieEventBus, List<WorkflowTask> workflowTasks, @Qualifier(value="jobsDir") Resource genieWorkingDir, Registry registry) {
        return new LocalJobRunner(jobPersistenceService, genieEventBus, workflowTasks, genieWorkingDir, registry);
    }

    @Bean
    public JobCoordinatorService jobCoordinatorService(JobPersistenceService jobPersistenceService, JobKillService jobKillService, @Qualifier(value="jobMonitoringCoordinator") JobStateService jobStateService, JobSearchService jobSearchService, JobsProperties jobsProperties, ApplicationService applicationService, ClusterService clusterService, CommandService commandService, List<ClusterLoadBalancer> clusterLoadBalancers, Registry registry, String hostName) {
        if (clusterLoadBalancers.isEmpty()) {
            throw new IllegalStateException("Must have at least one active implementation of ClusterLoadBalancer");
        }
        return new JobCoordinatorServiceImpl(jobPersistenceService, jobKillService, jobStateService, jobsProperties, applicationService, jobSearchService, clusterService, commandService, clusterLoadBalancers, registry, hostName);
    }

    @Bean
    public AttachmentService attachmentService(JobsProperties jobsProperties) {
        return new FileSystemAttachmentService(jobsProperties.getLocations().getAttachments());
    }

    @Bean
    public FactoryBean fileTransferFactory() {
        ServiceLocatorFactoryBean factoryBean = new ServiceLocatorFactoryBean();
        factoryBean.setServiceLocatorInterface(FileTransferFactory.class);
        return factoryBean;
    }

    @Bean
    public TagService tagService(JpaTagRepository tagRepository) {
        return new JpaTagServiceImpl(tagRepository);
    }

    @Bean
    public FileService fileService(JpaFileRepository fileRepository) {
        return new JpaFileServiceImpl(fileRepository);
    }
}

