/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.controllers;

import com.netflix.genie.web.controllers.ControllerUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Nullable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Controller
public class UIController {
    @GetMapping(value={"/", "/applications/**", "/clusters/**", "/commands/**", "/jobs/**", "/output/**"})
    public String getIndex(@NotNull HttpServletResponse response, @Nullable Authentication authentication) {
        if (authentication != null) {
            response.addCookie(new Cookie("genie.user", authentication.getName()));
        } else {
            response.addCookie(new Cookie("genie.user", "user@genie"));
        }
        return "index";
    }

    @GetMapping(value={"/file/{id}/**"})
    public String getFile(@PathVariable(value="id") String id, HttpServletRequest request) throws UnsupportedEncodingException {
        String encodedId = URLEncoder.encode(id, "UTF-8");
        String path = "/api/v3/jobs/" + encodedId + "/" + ControllerUtils.getRemainingPath(request);
        return "forward:" + path;
    }
}

