/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.health;

import com.netflix.genie.core.properties.HealthProperties;
import com.netflix.servo.monitor.BasicDistributionSummary;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.spectator.api.Registry;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.scheduling.TaskScheduler;

public class GenieCpuHealthIndicator
implements HealthIndicator {
    private static final Logger log = LoggerFactory.getLogger(GenieCpuHealthIndicator.class);
    private static final String CPU_LOAD = "cpuLoad";
    private final double maxCpuLoadPercent;
    private final int maxCpuLoadConsecutiveOccurrences;
    private final OperatingSystemMXBean operatingSystemMXBean;
    private final BasicDistributionSummary summaryCpuMetric;
    private int cpuLoadConsecutiveOccurrences;

    @Autowired
    public GenieCpuHealthIndicator(@NotNull HealthProperties healthProperties, @NotNull Registry registry, @NotNull TaskScheduler taskScheduler) {
        this(healthProperties.getMaxCpuLoadPercent(), healthProperties.getMaxCpuLoadConsecutiveOccurrences(), (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean(), new BasicDistributionSummary(MonitorConfig.builder((String)"genie.cpuLoad").build()), taskScheduler);
    }

    GenieCpuHealthIndicator(double maxCpuLoadPercent, int maxCpuLoadConsecutiveOccurrences, OperatingSystemMXBean operatingSystemMXBean, BasicDistributionSummary summaryCpuMetric, TaskScheduler taskScheduler) {
        this.maxCpuLoadPercent = maxCpuLoadPercent;
        this.maxCpuLoadConsecutiveOccurrences = maxCpuLoadConsecutiveOccurrences;
        this.operatingSystemMXBean = operatingSystemMXBean;
        this.summaryCpuMetric = summaryCpuMetric;
        this.summaryCpuMetric.record((long)(operatingSystemMXBean.getSystemCpuLoad() * 100.0));
        taskScheduler.scheduleAtFixedRate(() -> this.summaryCpuMetric.record((long)(operatingSystemMXBean.getSystemCpuLoad() * 100.0)), 5000L);
    }

    public Health health() {
        double currentCpuLoadPercent;
        long cpuCount = this.summaryCpuMetric.getCount();
        long cpuTotal = this.summaryCpuMetric.getTotalAmount();
        double d = currentCpuLoadPercent = cpuCount == 0L ? this.operatingSystemMXBean.getSystemCpuLoad() : (double)cpuTotal / (double)cpuCount;
        this.cpuLoadConsecutiveOccurrences = currentCpuLoadPercent > this.maxCpuLoadPercent ? ++this.cpuLoadConsecutiveOccurrences : 0;
        if (this.cpuLoadConsecutiveOccurrences >= this.maxCpuLoadConsecutiveOccurrences) {
            log.warn("CPU usage {} crossed the threshold of {}", (Object)currentCpuLoadPercent, (Object)this.maxCpuLoadPercent);
            return Health.outOfService().withDetail(CPU_LOAD, (Object)currentCpuLoadPercent).build();
        }
        return Health.up().withDetail(CPU_LOAD, (Object)currentCpuLoadPercent).build();
    }
}

