/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.security.oauth2.pingfederate;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.token.DefaultUserAuthenticationConverter;

public class PingFederateUserAuthenticationConverter
extends DefaultUserAuthenticationConverter {
    protected static final String CLIENT_ID_KEY = "client_id";
    protected static final String SCOPE_KEY = "scope";
    protected static final String GENIE_PREFIX = "genie_";
    protected static final String ROLE_PREFIX = "ROLE_";
    private static final GrantedAuthority USER_AUTHORITY = new SimpleGrantedAuthority("ROLE_USER");

    public Authentication extractAuthentication(Map<String, ?> map) {
        if (!map.containsKey(CLIENT_ID_KEY)) {
            throw new InvalidTokenException("No client id key found in map");
        }
        Object clientIdObject = map.get(CLIENT_ID_KEY);
        if (!(clientIdObject instanceof String)) {
            throw new InvalidTokenException("Client id wasn't string");
        }
        String userName = (String)clientIdObject;
        if (StringUtils.isBlank((CharSequence)userName)) {
            throw new InvalidTokenException("Client id was blank. Unable to use as user name");
        }
        Object scopeObject = map.get(SCOPE_KEY);
        if (!(scopeObject instanceof Collection)) {
            throw new InvalidTokenException("Scopes were not a collection");
        }
        Collection scopes = (Collection)scopeObject;
        if (scopes.isEmpty()) {
            throw new InvalidTokenException("No scopes available. Unable to authenticate");
        }
        HashSet authorities = Sets.newHashSet((Object[])new GrantedAuthority[]{USER_AUTHORITY});
        scopes.stream().filter(scope -> scope.contains(GENIE_PREFIX)).distinct().forEach(scope -> authorities.add(new SimpleGrantedAuthority(ROLE_PREFIX + StringUtils.removeStartIgnoreCase((String)scope, (String)GENIE_PREFIX).toUpperCase())));
        return new UsernamePasswordAuthenticationToken((Object)userName, (Object)"N/A", (Collection)authorities);
    }
}

