/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.tasks.leader;

import com.netflix.genie.core.jobs.JobConstants;
import com.netflix.genie.core.services.JobPersistenceService;
import com.netflix.genie.core.util.MetricsUtils;
import com.netflix.genie.web.properties.DatabaseCleanupProperties;
import com.netflix.genie.web.tasks.GenieTaskScheduleType;
import com.netflix.genie.web.tasks.TaskUtils;
import com.netflix.genie.web.tasks.leader.LeadershipTask;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.patterns.PolledMeter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"genie.tasks.databaseCleanup.enabled"})
@Component
public class DatabaseCleanupTask
extends LeadershipTask {
    private static final Logger log = LoggerFactory.getLogger(DatabaseCleanupTask.class);
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final DatabaseCleanupProperties cleanupProperties;
    private final JobPersistenceService jobPersistenceService;
    private final Registry registry;
    private final AtomicLong numDeletedJobs;
    private final Id deletionTimerId;

    @Autowired
    public DatabaseCleanupTask(@NotNull DatabaseCleanupProperties cleanupProperties, @NotNull JobPersistenceService jobPersistenceService, @NotNull Registry registry) {
        this.registry = registry;
        this.cleanupProperties = cleanupProperties;
        this.jobPersistenceService = jobPersistenceService;
        this.numDeletedJobs = (AtomicLong)((PolledMeter.Builder)PolledMeter.using((Registry)registry).withName("genie.tasks.databaseCleanup.numDeletedJobs.gauge")).monitorValue((Number)new AtomicLong());
        this.deletionTimerId = registry.createId("genie.tasks.databaseCleanup.duration.timer");
    }

    @Override
    public GenieTaskScheduleType getScheduleType() {
        return GenieTaskScheduleType.TRIGGER;
    }

    @Override
    public Trigger getTrigger() {
        return new CronTrigger(this.cleanupProperties.getExpression(), JobConstants.UTC);
    }

    @Override
    public void run() {
        long start = System.nanoTime();
        Map tags = MetricsUtils.newSuccessTagsMap();
        try {
            long numberDeletedJobs;
            Calendar cal = TaskUtils.getMidnightUTC();
            TaskUtils.subtractDaysFromDate(cal, this.cleanupProperties.getRetention());
            Date retentionLimit = cal.getTime();
            String retentionLimitString = this.dateFormat.format(retentionLimit);
            int batchSize = this.cleanupProperties.getMaxDeletedPerTransaction();
            int pageSize = this.cleanupProperties.getPageSize();
            log.info("Attempting to delete jobs from before {} in batches of {} jobs per iteration", (Object)retentionLimitString, (Object)batchSize);
            long totalDeletedJobs = 0L;
            do {
                numberDeletedJobs = this.jobPersistenceService.deleteBatchOfJobsCreatedBeforeDate(retentionLimit, batchSize, pageSize);
                totalDeletedJobs += numberDeletedJobs;
            } while (numberDeletedJobs != 0L);
            log.info("Deleted {} jobs from before {}", (Object)totalDeletedJobs, (Object)retentionLimitString);
            this.numDeletedJobs.set(totalDeletedJobs);
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException((Map)tags, (Throwable)t);
            throw t;
        }
        finally {
            long finish = System.nanoTime();
            this.registry.timer(this.deletionTimerId.withTags(tags)).record(finish - start, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public void cleanup() {
        this.numDeletedJobs.set(0L);
    }
}

